from os import path
from setuptools import setup, find_packages

HERE = path.abspath(path.dirname(__file__))
with open(path.join(HERE, 'README.md'), 'r', encoding = 'utf-8') as fh:
    long_description = fh.read()

setup(
    name = 'jupyter-cube-proxy',
    version = '4.9.1',
    packages = find_packages(),

    #url = 'https://',
    #download_url = 'https://'.format(version),

    author = 'Jens Henrik Goebbert',
    author_email = 'j.goebbert@fz-juelich.de',

    description = 'Cube for JupyterLab',
    long_description = long_description,
    long_description_content_type = 'text/markdown',

    keywords = ['jupyter', 'cube', 'jupyterhub', 'jupyter-server-proxy'],
    classifiers = [
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Framework :: Jupyter',
    ],

    entry_points = {
        'jupyter_serverproxy_servers': [
            'cube = jupyter_cube_proxy:setup_cube',
        ]
    },
    python_requires = '>=3.6',
    install_requires=[
        'jupyter-server-proxy>=4.0.0',
        'tornado>=6.3',
        'cube_webservice'
    ],
    package_data={
        'jupyter_cube_proxy': ['icons/Cube.svg'],
    },
    include_package_data = True,
    zip_safe = False
)
