import os
import logging


logging.basicConfig(
    level=logging.INFO,
    format="[%(levelname).1s %(asctime)s %(name)s] %(message)s",
    datefmt="%Y-%m-%d %H:%M:%S"
)
logger = logging.getLogger("jupyter_cube_proxy")


HERE = os.path.dirname(os.path.abspath(__file__))

def setup_cube():
    """ Setup commands and and return a dictionary compatible
        with jupyter-server-proxy.
    """
    from tempfile import mkdtemp

    # ensure a known secure sockets directory exists, as /run/user/$UID might not be available
    socket_path = mkdtemp(prefix='cube_sockets_' + str(os.getuid()) + '_')
    logger.info('Created secure socket directory for Cube: ' + socket_path)

    # start page on cube webserver
    path_info = 'cube/static/cube.html'

    # create command
    cmd = [
        'cube_webservice',
        '--unix-socket={unix_socket}',
        '--internal-socket=' + f'{socket_path}/cube-server.sock',
    ]
    
    logger.info('cube command: ' + ' '.join(cmd))

    return {
        'environment': {
            'XDG_RUNTIME_DIR': socket_path,
        },
        'command': cmd,
        'unix_socket': socket_path + '/cube-proxy.sock',
        'absolute_url': False,
        'timeout': 90,
        'new_browser_tab': True,
        'launcher_entry': {
            'enabled': True,
            'icon_path': os.path.join(HERE, 'icons/Cube.svg'),
            'title': 'Cube (4.9.1)',
            'path_info': path_info,
        },
        'progressive': True,
    }
