# Jupyter-Cube-Proxy
Integrate cube in your Jupyter environment

## Requirements
- Python 3.6+
- Jupyter Notebook 6.0+
- JupyterLab >= 3.x
- jupyter-server-proxy >= 4.0.0
- cube-webservice

Jupyter-Cube-Proxy is an implementation of Jupyter-Server-Proxy which handles starting and stopping of the Cube Web Service 
as a user process and ensures that the service is always available when the user accesses CubeGUI through the 
JupyterLab interface. It also manages the proxying of requests from the browser to the Cube Web Service.

This package executes cube-webservice, which is a tornado-based WebSocket proxy for cube_server.

### Cube Webservice
Cube Web Service provides access to the CubeGUI WASM client and proxies requests for data and
analysis operations via Unix domain sockets to the underlying cube server (part of cubelib).

### Jupyter-Server-Proxy
[Jupyter-Server-Proxy](https://jupyter-server-proxy.readthedocs.io) lets you run arbitrary external processes (such as `cube_webservice`) 
alongside your notebook, and provide authenticated web access to them.

## Install 

#### Create and activate environment
```
virtualenv -p python3 venv
source venv/bin/activate
```

#### Install and configure jupyter-cube-proxy
```
pip install .
```
