/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef POPSERVER_PLUGIN_H
#define POPSERVER_PLUGIN_H
 #include <vector>
#include "CubeServerPlugin.h"

namespace cube
{
class CubeProxy;
namespace popserver_plugin
{
/**
 * @brief The POPServerPlugin class  is working on server side plugins. It is called by the
 * corresponding client side plugin POP Advisor .
 */
class POPServerPlugin : public cube::CubeServerPlugin
{
public:
    /* used by the client to identify the server plugin */
    virtual const char*
    name() const override;

    /* used by the server api to send data to the plugin and receive an answer, which is send to the client plugin */
    std::vector<unsigned char>
    send( const std::vector<unsigned char>& dataFromClient,
          cube::CubeProxy*                  cube = nullptr ) override;
};
}
// the class factories which are required to create a plugin

extern "C" popserver_plugin::POPServerPlugin * create()
{
    return new popserver_plugin::POPServerPlugin();
}

extern "C" void
destroy( popserver_plugin::POPServerPlugin* plugin )
{
    delete plugin;
}
};

#endif
