/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_TRANSFER_TEST_H
#define CUBELIB_POP_HYBRID_TRANSFER_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace hybanalysis
{
class POPHybridCommunicationEfficiencyTest;
class POPHybridTransferTest : public popcalculation::PerformanceTest
{
    friend class POPHybridCommunicationEfficiencyTest;
private:
    cube::Metric* max_total_time_ideal;
    cube::Metric* max_total_time;

    cube::list_of_metrics lmax_total_time_ideal;

    void
    add_max_total_time_ideal( cube::CubeProxy* ) const;

    void
    add_max_total_time( cube::CubeProxy* ) const;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Transfer Efficiency (TE) measures inefficiencies due to time spent in data transfers:\n"
            "\tTE = maximum across processes(total runtime on ideal network) / maximum across processes(total measured runtime)\n\n"
            "where total runtime on ideal network is the runtime without the waiting time detected by Scalasca and MPI I/O time.";
        std::string not_active_text =
            "The Transfer Efficiency metric is only available if MPI wait states have been detected and measured.\n"
            "Hence, it is only available for trace analysis results from Scalasca, such as scout.cubex or trace.cubex.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridTransferTest( cube::CubeProxy* );

    virtual
    ~POPHybridTransferTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
