/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_SERIALISATION_TEST_H
#define CUBELIB_POP_HYBRID_SERIALISATION_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace hybanalysis
{
class POPHybridCommunicationEfficiencyTest;
class POPHybridSerialisationTest : public popcalculation::PerformanceTest
{
    friend class POPHybridCommunicationEfficiencyTest;
private:
    cube::Metric*         max_omp_serial_comp_time;
    cube::Metric*         max_total_time_ideal;
    cube::list_of_metrics lmax_omp_serial_comp_time;

    void
    add_max_total_time_ideal_hyb( cube::CubeProxy* ) const;

    void
    add_transfer_time_mpi( cube::CubeProxy* ) const;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Serialization Efficiency (SerE) quantifies communication bottlenecks by measuring process idle time during MPI operations.\n"
            "It uses this formula: SerE = max_processes(computation_time / (runtime_without_waits - MPI_I/O_time))\n"
            "where runtime_without_waits represents the time Scalasca calculates would occur on an idealized network without synchronization delays.";

        std::string not_active_text =
            "Serialization Efficiency requires detailed MPI trace data that only Score-P/Scalasca can provide.\n"
            "This metric is unavailable for Cube reports generated without MPI wait state detection, including those from tools other than Scalasca.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridSerialisationTest( cube::CubeProxy* );

    virtual
    ~POPHybridSerialisationTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
