/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_PROCESS_EFFICIENCY_TEST_H
#define CUBELIB_POP_HYBRID_PROCESS_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "POPHybridImbalanceTest.h"
#include "POPHybridCommunicationEfficiencyTest.h"

namespace hybanalysis
{
class POPHybridParallelEfficiencyTest;
class POPHybridProcessEfficiencyTest : public popcalculation::PerformanceTest
{
    friend  class POPHybridParallelEfficiencyTest;

private:


    POPHybridImbalanceTest*               pop_lb;
    POPHybridCommunicationEfficiencyTest* pop_commeff;


    cube::Metric* max_runtime;
    cube::Metric* pop_avg_omp;
    cube::Metric* pop_avg_ser_comp;

    cube::list_of_metrics max_runtime_metrics;
    cube::list_of_metrics lavg_omp_metrics;
    cube::list_of_metrics lavg_ser_metrics;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );

protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Process Efficiency evaluates pure process-level performance by analyzing:\n"
            "1. Workload distribution across processes (Computation Load Balance)\n"
            "2. Inter-process communication effectiveness (MPI Communication Efficiency)\n"
            "It can be calculated using either approach:\n"
            "PE = (avg(OpenMP_time) + avg(serial_computation)) / max(process_runtime)\n"
            "or\n"
            "PE = Computation_Load_Balance x MPI_Communication_Efficiency\n"
            "Note: Thread-specific averages use weighted arithmetic mean by default,\n"
            "switching to ordinary arithmetic mean when threads are uniformly distributed.";

        std::string not_active_text =
            "Process Efficiency depends on precise timing data from Score-P/Scalasca measurements.\n"
            "Reports generated by other tools may lack the required 'Time' metric,\n"
            "which would prevent both direct calculation and POP analysis of process efficiency.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    POPHybridProcessEfficiencyTest(      cube::CubeProxy*,
                                         POPHybridImbalanceTest*               pop_lb,
                                         POPHybridCommunicationEfficiencyTest* pop_commeff );

    virtual
    ~POPHybridProcessEfficiencyTest()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( pop_lb != nullptr && pop_commeff != nullptr )
        {
            prereqs.push_back( pop_lb );
            prereqs.push_back( pop_commeff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
