/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_TRANSFER_TEST_ADD_H
#define CUBELIB_POP_HYBRID_TRANSFER_TEST_ADD_H

#include <string>
#include "PerformanceTest.h"


namespace hybaddanalysis
{
class POPHybridCommunicationEfficiencyTestAdd;
class POPHybridTransferTestAdd : public popcalculation::PerformanceTest
{
    friend class POPHybridCommunicationEfficiencyTestAdd;
private:
    cube::Metric* max_total_time_ideal;
    cube::Metric* max_total_time;

    cube::list_of_metrics lmax_total_time_ideal;

    void
    add_max_total_time_ideal( cube::CubeProxy* ) const;

    void
    add_max_total_time( cube::CubeProxy* ) const;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Transfer Efficiency (TE) quantifies inefficiencies caused by time spent on data transfers.\n"
            "It is calculated as:\n"
            "\tTE = (maximum across processes of ideal network runtime)\n"
            "\t      / (maximum across processes of measured runtime)\n"
            "\n"
            "Note: The 'ideal network runtime' represents the execution time without Scalasca-detected waiting periods\n"
            "and MPI I/O operations.";

        std::string not_active_text =
            "The Transfer Efficiency metric is only available when MPI wait states have been detected and measured.\n"
            "Consequently, it is exclusively applicable to Scalasca trace analysis results such as:\n"
            "\t- scout.cubex files\n"
            "\t- trace.cubex files";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridTransferTestAdd( cube::CubeProxy* );

    virtual
    ~POPHybridTransferTestAdd()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
