/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_SERIALISATION_TEST_ADD_H
#define CUBELIB_POP_HYBRID_SERIALISATION_TEST_ADD_H

#include <string>
#include "PerformanceTest.h"


namespace hybaddanalysis
{
class POPHybridCommunicationEfficiencyTestAdd;
class POPHybridSerialisationTestAdd : public popcalculation::PerformanceTest
{
    friend class POPHybridCommunicationEfficiencyTestAdd;
private:
    cube::Metric*         max_omp_serial_comp_time;
    cube::Metric*         max_total_time_ideal;
    cube::list_of_metrics lmax_omp_serial_comp_time;


    void
    add_max_total_time_ideal_hyb( cube::CubeProxy* ) const;

    void
    add_transfer_time_mpi( cube::CubeProxy* ) const;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Serialisation Efficiency (SerE) measures inefficiency due to idle time within communications, \n"
            "i.e. time where no data is transferred, and is expressed as:\n"
            "\t SerE = maximum across processes(computation time / total  runtime on ideal network) \n\n"
            "where total run-time on ideal network is a runtime without detected by Scalasca waiting time and MPI I/O time.";

        std::string not_active_text =
            "Serialisation Efficiency metric is available only, if MPI wait states have been detected and measured. \n"
            "Hence it is only available for trace analysis results of Scalasca such as scout.cubex or trace.cubex";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridSerialisationTestAdd( cube::CubeProxy* );

    virtual
    ~POPHybridSerialisationTestAdd()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
