/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_AUDIT_PERFORMANCE_ANALYSIS_ADD_H
#define CUBELIB_POP_HYBRID_AUDIT_PERFORMANCE_ANALYSIS_ADD_H

#include <string>
#include "Cube.h"


#include "PerformanceAnalysis.h"
#include "PerformanceTest.h"


#include "POPComputationTimeTest.h"
#include "POPGPUComputationTimeTest.h"
#include "POPHybridAmdahlTestAdd.h"
#include "POPHybridCommunicationEfficiencyTestAdd.h"
#include "POPHybridImbalanceTestAdd.h"
#include "POPHybridOMPRegionEfficiencyTestAdd.h"
#include "POPHybridParallelEfficiencyTestAdd.h"
#include "POPHybridProcessEfficiencyTestAdd.h"
#include "POPHybridSerialisationTestAdd.h"
#include "POPHybridThreadEfficiencyTestAdd.h"
#include "POPHybridTransferTestAdd.h"
#include "POPIPCTest.h"
#include "POPNoWaitINSTest.h"
#include "POPStalledResourcesTest.h"
#include "POPWallTimeTest.h"
#include "POPIOEfficiencyTest.h"
#include "POPMpiIOTimeTest.h"
#include "POPPosixIOTimeTest.h"

#include "POPGPUParallelTest.h"
#include "POPGPUCommunicationEfficiencyTest.h"
#include "POPGPUImbalanceTest.h"


namespace hybaddanalysis
{
class POPHybridAuditPerformanceAnalysisAdd : public popcalculation::PerformanceAnalysis
{
protected:

    popcalculation::POPStalledResourcesTest* stalled_resources;
    popcalculation::POPNoWaitINSTest*        no_wait_ins;
    popcalculation::POPIPCTest*              ipc;
    popcalculation::POPWallTimeTest*         wall;
    popcalculation::POPComputationTime*      comp;
    popcalculation::POPGPUComputationTime*   gpu_comp;
    popcalculation::POPPosixIOTime*          posix_io;
    popcalculation::POPMpiIOTime*            mpi_io;
    popcalculation::POPIOEfficiencyTest*     io_eff;

    POPHybridTransferTestAdd*                pop_transfer_eff;
    POPHybridSerialisationTestAdd*           pop_ser_eff;
    POPHybridCommunicationEfficiencyTestAdd* comm_eff;
    POPHybridImbalanceTestAdd*               lb_eff;
    POPHybridProcessEfficiencyTestAdd*       proc_eff;

    POPHybridOmpRegionEfficiencyTestAdd* omp_region_eff;
    POPHybridAmdahlTestAdd*              pop_amdahl_eff;

    POPHybridThreadEfficiencyTestAdd* thread_eff;

    POPHybridParallelEfficiencyTestAdd* par_eff;

    popcalculation::POPGPUCommunicationEfficiencyTest* gpu_comm_eff;
    popcalculation::POPGPUImbalanceTest*               gpu_lb_eff;
    popcalculation::POPGPUParallelEfficiencyTest*      gpu_par_eff;


    double max_ipc;

public:
    POPHybridAuditPerformanceAnalysisAdd( cube::CubeProxy* _cube );

    virtual
    ~POPHybridAuditPerformanceAnalysisAdd();


    virtual
    inline
    std::string
    name() const
    {
        return "Additive Hybrid Assessment";
    }

    // returns list of tests, which can be calculated independentely in sepaate tasks
    virtual
    std::list<popcalculation::PerformanceTest*>
    getAllTestsForCalculation();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getPOPTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getGPUTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getIOTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getAdditionalTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getControlTests();


    virtual
    std::string
    getAnchorHowToMeasure();

// ------ overview tests ---------

    virtual
    bool
    isActive() const;
};
};

#endif // ADVISER_RATING_WIDGET_H
