/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_AMDAHL_TEST_ADD_H
#define CUBELIB_POP_HYBRID_AMDAHL_TEST_ADD_H

#include <string>
#include "PerformanceTest.h"


namespace hybaddanalysis
{
class POPHybridParallelEfficiencyTest;
class POPHybridAmdahlTestAdd : public popcalculation::PerformanceTest
{
    friend class POPHybridParallelEfficiencyTest;
private:
    cube::Metric* pop_ser_comp_comp;
    cube::Metric* max_runtime;

    cube::list_of_metrics lmax_runtime_metrics;

    void
    add_amdahl( cube::CubeProxy* ) const;

    void
    add_avg_comp( cube::CubeProxy* ) const;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        const std::string active_text =
            "Amdahl's Law Efficiency indicates serial computation and can be computed as follows:\n"
            "\tAmdahl's Efficiency = (max(runtime) - avg(idling time of OpenMP threads)) / max(runtime)\n"
            "where the average idling time of OpenMP threads is calculated when only the master thread is working.\n"
            "This can be computed using the following formula:\n"
            "\taverage idling time = \n"
            "\tSUM (FROM process = 0 TO (number of processes - 1)) \n"
            "\t\t(serial computation * (number of threads per process - 1)) / (total number of threads)";

        const std::string not_active_text =
            "Amdahl's Law Efficiency is a basic POP metric\n"
            "and is available in every Score-P/Scalasca measurement.\n"
            "If the Cube Report was generated by another tool instead of Score-P/Scalasca,\n"
            "it may lack the 'Time' metric, making POP analysis impossible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridAmdahlTestAdd( cube::CubeProxy* );

    virtual
    ~POPHybridAmdahlTestAdd()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
