/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_GPU_POP_COMPUTATION_TIME_H
#define CUBELIB_GPU_POP_COMPUTATION_TIME_H

#include <string>
#include "PerformanceTest.h"


namespace popcalculation
{
class POPGPUComputationTime : public PerformanceTest
{
private:
    cube::Metric* gpu_comp;
    bool          is_active;

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "GPU Computation Time represents the duration spent executing computationally intensive operations\n"
            "on GPU hardware within marked GPU regions of the code.\n"
            "This metric specifically captures the portion of total computation time that is offloaded to and executed\n"
            "by the GPU, excluding any data transfer or overhead operations.";

        std::string not_active_text =
            "The GPU Computation Time metric is available only in Score-P/Scalasca measurements that:\n"
            "\t- Include proper Time metric instrumentation, and\n"
            "\t- Are executed on systems with GPU hardware.\n"
            "When Cube Reports are generated by alternative profiling tools or when:\n"
            "\t- The essential Time metric is missing, or\n"
            "\t- There is no GPU instrumentation present,\n"
            "the GPU Computation Time metric will be reported as Not a Number (NAN).\n"
            "This occurs because the required timing and hardware-specific data cannot be properly extracted.";

        return active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPGPUComputationTime( cube::CubeProxy* );

    virtual
    ~POPGPUComputationTime()
    {
    };
// ------ overview tests ---------


    virtual
    inline
    bool
    isPercent() const
    {
        return false;
    }

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isNormalized() const // returns true, if range goes from 0 to 1. false -> otherwise
    {
        return false;
    }

    inline
    virtual
    std::string
    units() const
    {
        return "sec";
    }
};
};
#endif // POP_ipc_TEST_H
