/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>

#include "POPGPUComputationTimeTest.h"


using namespace popcalculation;

POPGPUComputationTime::POPGPUComputationTime( cube::CubeProxy* cube ) : PerformanceTest( cube )
{
    setName(  "GPU Computation time" );
    setWeight( 1 );   // need to be adjusted
    gpu_comp = cube->getMetric( "gpu_comp_time" );
    if ( gpu_comp == nullptr )
    {
        setWeight( 0.1 );
        setValue( 0. );
        return;
    }
    cube::list_of_sysresources lsysres = getRootsOfSystemTree();
    cube::metric_pair          metric;
    metric.first  = gpu_comp;
    metric.second = cube::CUBE_CALCULATE_INCLUSIVE;
    lmetrics.push_back( metric );


    const std::vector<cube::Location*>& _locs = cube->getLocations();
    is_active = false;
    for ( std::vector<cube::Location*>::const_iterator iter = _locs.begin(); iter != _locs.end(); ++iter )
    {
        if ( ( *iter )->get_type() == cube::CUBE_LOCATION_TYPE_GPU )
        {
            is_active = true;
            break;
        }
    }
}


void
POPGPUComputationTime::applyCnode( const cube::list_of_cnodes& lcnodes,
                                   const bool                  direct_calculation  )
{
    ( void )direct_calculation; // not used here
    if ( gpu_comp == nullptr )
    {
        return;
    }
    cube::list_of_sysresources lsysres;
    cube::Value*               v = cube->calculateValue( lmetrics,
                                                         lcnodes,
                                                         lsysres );
    double comp_value = v->getDouble();
    delete v;
    setValue( comp_value );
}

const std::string&
POPGPUComputationTime::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
POPGPUComputationTime::isActive() const
{
    return is_active;
};

bool
POPGPUComputationTime::isIssue() const
{
    return false;
};



void
POPGPUComputationTime::adjustForTest( cube::CubeProxy* cube ) const
{
    ( void )cube;
}
