/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_WALL_TIME_TEST_H
#define CUBELIB_POP_WALL_TIME_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace popcalculation
{
class POPWallTimeTest : public PerformanceTest
{
private:
    cube::Metric* pop_walltime;
    double        maxValue;


protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "The WallClock Time metric evaluates measurement quality by showing the minimum, average, \n"
            "and maximum runtimes across the system hierarchy. Users should verify this data to confirm \n"
            "the measurement's validity for POP analysis.\n"
            "\n"
            "Significant outliers or extreme runtime variations (e.g., drastic differences between CPUs) \n"
            "typically indicate measurement errors, making the data unsuitable for analysis. In such cases, \n"
            "it is strongly recommended to perform the measurement again.\n";

        std::string not_active_text =
            "The WallClock Time metric requires the presence of time measurement data in Score-P or Scalasca.\n"
            "If the Cube Report was generated by a different tool, it may lack the essential Time metric,\n"
            "resulting in computation time data being unavailable and this metric reported as 'NAN'.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* ) const;

public:
    POPWallTimeTest( cube::CubeProxy* );

    virtual
    ~POPWallTimeTest()
    {
    };
// ------ overview tests ---------

    virtual
    inline
    double
    getMaximum() const
    {
        return maxValue;
    }

    virtual
    inline
    bool
    isPercent() const
    {
        return false;
    }

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isNormalized() const // returns true, if range goes from 0 to 1. false -> otherwise
    {
        return false;
    }
};
};
#endif // POP_ipc_TEST_H
