/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_POSIX_IO_TIME_H
#define CUBELIB_POP_POSIX_IO_TIME_H

#include <string>
#include "PerformanceTest.h"


namespace popcalculation
{
class POPIOEfficiencyTest;
class POPPosixIOTime : public PerformanceTest
{
    friend class POPIOEfficiencyTest;
private:
    cube::Metric*         execution;
    cube::Metric*         posix_io;
    cube::list_of_metrics lposix_io_metrics;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "POSIX IO Efficiency measures the proportion of execution time spent in POSIX I/O operations.\n"
            "The metric is calculated as:\n"
            "\tPOSIX IO = (Time spent in POSIX I/O calls) / (Total runtime)\n";

        std::string not_active_text =
            "The POSIX IO Efficiency metric is only available in Score-P or Scalasca measurements\n"
            "where POSIX I/O calls were recorded. If the Cube Report originates from a different tool,\n"
            "it may lack the required Time and I/O Time measurements, making this analysis impossible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPPosixIOTime( cube::CubeProxy* );

    virtual
    ~POPPosixIOTime()
    {
    };
// ------ overview tests ---------


    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    inline
    bool
    isPercent() const
    {
        return false;
    }

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isNormalized() const // returns true, if range goes from 0 to 1. false -> otherwise
    {
        return false;
    }

    inline
    virtual
    std::string
    units() const
    {
        return "sec";
    }
};
};
#endif // POP_ipc_TEST_H
