/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>

#include "POPPosixIOTimeTest.h"


using namespace popcalculation;

POPPosixIOTime::POPPosixIOTime( cube::CubeProxy* cube ) : PerformanceTest( cube )
{
    setName(  " * Posix I/O time" );
    setWeight( 1 );   // need to be adjusted
    execution = cube->getMetric( "execution" );
    if ( execution == nullptr )
    {
        setWeight( 0.1 );
        setValue( 0. );
        return;
    }
    posix_io = cube->getMetric( "posix_io" );
    if ( posix_io == nullptr )
    {
        setWeight( 0.1 );
        setValue( 0. );
        return;
    }
    cube::list_of_sysresources lsysres = getRootsOfSystemTree();
    cube::metric_pair          metric;
    metric.first  = execution;
    metric.second = cube::CUBE_CALCULATE_INCLUSIVE;
    lmetrics.push_back( metric );

    metric.first  = posix_io;
    metric.second = cube::CUBE_CALCULATE_INCLUSIVE;
    lposix_io_metrics.push_back( metric );
}

void
POPPosixIOTime::applyCnode( const cube::list_of_cnodes& lcnodes,
                            const bool                  direct_calculation  )
{
    ( void )direct_calculation; // not used here
    if ( execution == nullptr || posix_io == nullptr )
    {
        return;
    }
    cube::list_of_sysresources lsysres;

    cube::Value* v = cube->calculateValue( lmetrics,
                                           lcnodes,
                                           lsysres );
    cube::Value* io_v = cube->calculateValue( lposix_io_metrics,
                                              lcnodes,
                                              lsysres );
    double comp_value = v->getDouble();
    delete v;
    double posix_io_value = io_v->getDouble();
    delete io_v;
    setValue( ( comp_value != 0. ) ? ( posix_io_value / comp_value ) : -1 );
}

const std::string&
POPPosixIOTime::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
POPPosixIOTime::isActive() const
{
    return execution != nullptr && posix_io != nullptr && !posix_io->isInactive();
};

bool
POPPosixIOTime::isIssue() const
{
    return false;
};



void
POPPosixIOTime::adjustForTest( cube::CubeProxy* cube ) const
{
    ( void )cube;
}
