/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_MPI_IO_TIME_H
#define CUBELIB_POP_MPI_IO_TIME_H

#include <string>
#include "PerformanceTest.h"


namespace popcalculation
{
class POPIOEfficiencyTest;
class POPMpiIOTime : public PerformanceTest
{
    friend class POPIOEfficiencyTest;

private:
    cube::Metric*         execution;
    cube::Metric*         mpi_io;
    cube::list_of_metrics lmpi_io_metrics;

protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "MPI IO Efficiency measures what fraction of execution time was spent in MPI I/O operations.\n"
            "The metric is calculated as:\n"
            "\tMPI IO = (Time spent in MPI I/O calls) / (Total runtime)\n";

        std::string not_active_text =
            "The MPI IO Efficiency metric is only available in Score-P or Scalasca measurements \n"
            "where MPI I/O calls were recorded. If the Cube Report was generated by a different tool, \n"
            "it may lack the required Time and I/O Time measurements, resulting in this metric being \n"
            "reported as 'NAN' (Not A Number).";
        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPMpiIOTime( cube::CubeProxy* );

    virtual
    ~POPMpiIOTime()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    inline
    bool
    isPercent() const
    {
        return false;
    }

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isNormalized() const // returns true, if range goes from 0 to 1. false -> otherwise
    {
        return false;
    }

    inline
    virtual
    std::string
    units() const
    {
        return "sec";
    }
};
};
#endif // POP_ipc_TEST_H
