/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_IPC_TEST_H
#define CUBELIB_POP_IPC_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace popcalculation
{
class POPIPCTest : public PerformanceTest
{
private:
    cube::Metric* pop_ipc;
    double        maxValue;


protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "IPC Efficiency compares your current IPC to a reference value. Lower IPC indicates \n"
            "a reduced rate of computation. Common causes include:\n"
            "- Decreased cache hit rate, forcing more memory accesses\n"
            "- Memory bandwidth saturation, causing stall cycles\n"
            "These issues may leave processes waiting for data instead of executing instructions.\n";

        std::string not_active_text =
            "The IPC Efficiency metric requires either:\n"
            "- PAPI counters PAPI_TOT_INS (instructions) and PAPI_TOT_CYC (cycles), or\n"
            "- Perf counters for instructions and cycles.\n"
            "To enable this measurement, please refer to the Score-P manual's section on \n"
            "perf counters configuration (PERF COUNTERS).";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPIPCTest( cube::CubeProxy* );

    virtual
    ~POPIPCTest()
    {
    };
// ------ overview tests ---------

    virtual
    inline
    double
    getMaximum() const
    {
        return maxValue;
    }

    virtual
    inline
    bool
    isPercent() const
    {
        return false;
    }

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isNormalized() const // returns true, if range goes from 0 to 1. false -> otherwise
    {
        return false;
    }
};
};
#endif // POP_ipc_TEST_H
