/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>

#include "POPIPCTest.h"


using namespace popcalculation;

POPIPCTest::POPIPCTest( cube::CubeProxy* cube ) : PerformanceTest( cube )
{
    setName( "IPC" );
    setWeight( 1 );   // need to be adjusted
    pop_ipc = cube->getMetric( "ipc" );
    if ( pop_ipc == nullptr )
    {
        adjustForTest( cube );
    }
    pop_ipc  = cube->getMetric( "ipc" );
    maxValue = 1.;
    if ( pop_ipc == nullptr )
    {
        setWeight( 0.1 );
        setValue( 0. );
        return;
    }
    cube::list_of_sysresources lsysres = getRootsOfSystemTree();
    cube::metric_pair          metric;
    metric.first  = pop_ipc;
    metric.second = cube::CUBE_CALCULATE_INCLUSIVE;
    lmetrics.push_back( metric );
}


void
POPIPCTest::applyCnode( const cube::list_of_cnodes& lcnodes,
                        const bool                  direct_calculation  )
{
    ( void )direct_calculation; // not used here
    if ( pop_ipc == nullptr )
    {
        return;
    }

    cube::list_of_sysresources lsysres;
    cube::Value*               v = cube->calculateValue( lmetrics,
                                                         lcnodes,
                                                         lsysres );
    double pop_ipc_value = v->getDouble();
    delete v;
    setValue( pop_ipc_value );
}

const std::string&
POPIPCTest::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
POPIPCTest::isActive() const
{
    return pop_ipc != nullptr;
};

bool
POPIPCTest::isIssue() const
{
    return false;
};


void
POPIPCTest::adjustForTest( cube::CubeProxy* cube ) const
{
    add_tot_ins_without_wait( cube );
    add_tot_cyc_without_wait( cube );
    add_ipc( cube );
}
