/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>

#include "POPComputationTimeTest.h"


using namespace popcalculation;

POPComputationTime::POPComputationTime( cube::CubeProxy* cube ) : PerformanceTest( cube )
{
    setName(  "Computation time" );
    setWeight( 1 );   // need to be adjusted
    comp = cube->getMetric( "comp" );
    if ( comp == nullptr )
    {
        setWeight( 0.1 );
        setValue( 0. );
        return;
    }
    cube::list_of_sysresources lsysres = getRootsOfSystemTree();
    cube::metric_pair          metric;
    metric.first  = comp;
    metric.second = cube::CUBE_CALCULATE_INCLUSIVE;
    lmetrics.push_back( metric );
}


void
POPComputationTime::applyCnode( const cube::list_of_cnodes& lcnodes,
                                const bool                  direct_calculation  )
{
    ( void )direct_calculation; // not used here
    if ( comp == nullptr )
    {
        return;
    }
    cube::list_of_sysresources lsysres;
    cube::Value*               v = cube->calculateValue( lmetrics,
                                                         lcnodes,
                                                         lsysres );
    double comp_value = v->getDouble();
    delete v;
    setValue( comp_value );
}

const std::string&
POPComputationTime::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
POPComputationTime::isActive() const
{
    return comp != nullptr;
};

bool
POPComputationTime::isIssue() const
{
    return false;
};



void
POPComputationTime::adjustForTest( cube::CubeProxy* cube ) const
{
    ( void )cube;
}
