/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef POPCALCULATION_H
#define POPCALCULATION_H

#include <vector>
#include <utility>
#include <stdint.h>
#include "CubeIoProxy.h"

namespace popcalculation
{
enum  POP_ANALYSIS
{
    PURE_MPI    = 0,
    HYBRID_ADD  = 1,
    HYBRID_MULT = 2,
    HYBRID_BSC  = 3
};




/**
 * @brief The POPServerPlugin class  is working on server side plugins. It is called by the
 * corresponding client side plugin POP Advisor .
 */
class POPCalculation
{
public:

    /* used by the server api to send data to the plugin and receive an answer, which is send to the client plugin */
    static
    std::vector<unsigned char>
    calculate(  const std::vector<unsigned char>& request,
                cube::CubeIoProxy*                cube );


    static
    void
    correctCnodes( cube::CubeProxy*,
                   cube::list_of_cnodes&
                   );

    static
    size_t
    get_num_thread_children( const cube::LocationGroup* );
};
};

#endif
