/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_PARALLEL_EFFICIENCY_TEST_H
#define CUBELIB_BSPOP_HYBRID_PARALLEL_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "BSPOPHybridCommunicationEfficiencyTest.h"
#include "BSPOPHybridLoadBalanceTest.h"

namespace bscanalysis
{
class BSPOPHybridOMPParallelEfficiencyTest;
class BSPOPHybridParallelEfficiencyTest : public popcalculation::PerformanceTest
{
    friend class BSPOPHybridOMPParallelEfficiencyTest;
private:
    cube::Metric* pop_avg_comp;
    cube::Metric* max_runtime;

    cube::list_of_metrics max_runtime_metrics;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );

protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Hybrid Parallel Efficiency (HPE) assesses the overall effectiveness of combined MPI and OpenMP parallelization.\n"
            "This metric evaluates how well processes and threads work together in terms of workload distribution\n"
            "and communication overhead. HPE can be calculated either directly or through its fundamental components:\n"
            "\tHPE = average(computation time across all processes and threads) / maximum(total runtime)\n"
            "\nAlternative product-based calculation:\n"
            "\tHPE = Hybrid Load Balance Efficiency x Hybrid Communication Efficiency\n\n"
            "HPE provides comprehensive insight into the performance of mixed MPI/OpenMP parallel applications.";

        std::string not_active_text =
            "The Hybrid Parallel Efficiency (HPE) metric relies on comprehensive timing data from Score-P/Scalasca.\n"
            "It is only fully available when using the complete Score-P/Scalasca measurement infrastructure.\n"
            "Cube Reports generated by alternative tools may contain incomplete timing information,\n"
            "particularly the essential Time metric required for accurate analysis.\n"
            "Without this critical timing data, POP analysis of Hybrid Parallel Efficiency\n"
            "cannot be calculated, potentially leading to incomplete or inaccurate performance evaluations.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    BSPOPHybridParallelEfficiencyTest(  cube::CubeProxy*  );

    virtual
    ~BSPOPHybridParallelEfficiencyTest()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // ADVISER_RATING_WIDGET_H
