/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_OMP_LOAD_BALANCE_EFFICIENCY_TEST_H
#define CUBELIB_BSPOP_HYBRID_OMP_LOAD_BALANCE_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "BSPOPHybridMPILoadBalanceTest.h"
#include "BSPOPHybridLoadBalanceTest.h"


namespace bscanalysis
{
class BSPOPHybridOMPLoadBalanceEfficiencyTest : public popcalculation::PerformanceTest
{
private:

    BSPOPHybridLoadBalanceTest*    par_lb_eff;
    BSPOPHybridMPILoadBalanceTest* mpi_lb_eff;

    void
    calculate();

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );



    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "OpenMP Load Balance Efficiency evaluates the balance between OpenMP and MPI workload distribution.\n"
            "It is calculated using:\n"
            "\tOpenMP Load Balance Efficiency = (Hybrid Load Balance Efficiency) / (MPI Load Balance Efficiency)\n\n"
            "This metric reveals any imbalances in how computational workload is divided\n"
            "between OpenMP threads and MPI processes.";

        std::string not_active_text =
            "OpenMP Load Balance Efficiency analysis depends on complete Score-P/Scalasca measurement data.\n"
            "The metric is fully available only when using standardized Score-P/Scalasca instrumentation.\n"
            "Reports generated by alternative tools may be missing critical timing metrics,\n"
            "particularly the Time metric, which are essential for accurate POP analysis.\n"
            "Without these metrics, proper evaluation of OpenMP load balancing efficiency cannot be performed.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    BSPOPHybridOMPLoadBalanceEfficiencyTest(     cube::CubeProxy*,
                                                 BSPOPHybridLoadBalanceTest*,
                                                 BSPOPHybridMPILoadBalanceTest*
                                                 );

    virtual
    ~BSPOPHybridOMPLoadBalanceEfficiencyTest()
    {
    };
// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( par_lb_eff != nullptr && mpi_lb_eff != nullptr )
        {
            prereqs.push_back( par_lb_eff );
            prereqs.push_back( mpi_lb_eff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
