/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_OMP_COMMUNICATION_TEST_H
#define CUBELIB_BSPOP_HYBRID_OMP_COMMUNICATION_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "BSPOPHybridMPICommunicationEfficiencyTest.h"
#include "BSPOPHybridCommunicationEfficiencyTest.h"


namespace bscanalysis
{
class BSPOPHybridOMPCommunicationEfficiencyTest : public popcalculation::PerformanceTest
{
private:

    BSPOPHybridCommunicationEfficiencyTest*    par_comm_eff;
    BSPOPHybridMPICommunicationEfficiencyTest* mpi_comm_eff;

    void
    calculate();

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );



    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "OpenMP Efficiency evaluates how effectively the application utilizes OpenMP parallelization.\n"
            "It can be calculated either directly or through the relationship between:\n"
            "\tOpenMP Efficiency = max(computation time) / max(total parallel execution time outside MPI calls)\n"
            "or alternatively as:\n"
            "\t                 = Hybrid Communication Efficiency / MPI Communication Efficiency\n\n"
            "This metric specifically measures efficiency of OpenMP-directed parallel computations.";

        std::string not_active_text =
            "OpenMP Efficiency analysis requires comprehensive timing data from Score-P/Scalasca measurements.\n"
            "This metric is only fully available when using official Score-P/Scalasca instrumentation.\n"
            "Cube Reports generated by third-party tools may lack the necessary timing information,\n"
            "particularly the Time metric, which would prevent accurate Performance Overhead and Productivity (POP) analysis.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    BSPOPHybridOMPCommunicationEfficiencyTest( cube::CubeProxy*,
                                               BSPOPHybridCommunicationEfficiencyTest*,
                                               BSPOPHybridMPICommunicationEfficiencyTest* );

    virtual
    ~BSPOPHybridOMPCommunicationEfficiencyTest()
    {
    };

// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( par_comm_eff != nullptr && mpi_comm_eff != nullptr )
        {
            prereqs.push_back( par_comm_eff );
            prereqs.push_back( mpi_comm_eff );
        }
        return prereqs;
    }
};
};
#endif // BSPOPHybrid_IMBALANCE_TEST_H
