/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <future>
#include <thread>
#include <limits>
#include "BSPOPHybridOMPCommunicationEfficiencyTest.h"


using namespace bscanalysis;

BSPOPHybridOMPCommunicationEfficiencyTest::BSPOPHybridOMPCommunicationEfficiencyTest( cube::CubeProxy*                           cube,
                                                                                      BSPOPHybridCommunicationEfficiencyTest*    _par_comm_eff,
                                                                                      BSPOPHybridMPICommunicationEfficiencyTest* _mpi_comm_eff ) : popcalculation::PerformanceTest( cube ),
    par_comm_eff( _par_comm_eff ),
    mpi_comm_eff( _mpi_comm_eff )
{
    setName( " * OpenMP Communication Efficiency" );
    setWeight( 1 );   // need to be adjusted
    if ( par_comm_eff == nullptr || mpi_comm_eff == nullptr  ||
         ( !par_comm_eff->isActive() && !mpi_comm_eff->isActive() )
         )
    {
        setWeight( 0.2 );
        setValue( 0. );
        return;
    }
}


void
BSPOPHybridOMPCommunicationEfficiencyTest::calculate()
{
    if ( par_comm_eff == nullptr || mpi_comm_eff == nullptr  ||
         ( !par_comm_eff->isActive() && !mpi_comm_eff->isActive()  ) )
    {
        return;
    }
    double par_comm_eff_value = par_comm_eff->value();
    double mpi_comm_eff_value = mpi_comm_eff->value();
    setValue( ( par_comm_eff->isActive() ? par_comm_eff_value : 1. ) /
              ( mpi_comm_eff->isActive() && ( mpi_comm_eff_value > std::numeric_limits<double>::min() ) ? mpi_comm_eff_value : 1. ) );
}


static
void
par_comm_task_full_( BSPOPHybridCommunicationEfficiencyTest* _par_comm_eff,
                     const cube::list_of_cnodes&             cnodes )
{
    if ( _par_comm_eff )
    {
        _par_comm_eff->applyCnode( cnodes );
    }
}

static
void
mpi_comm_task_full_( BSPOPHybridMPICommunicationEfficiencyTest* _mpi_comm_eff,
                     const cube::list_of_cnodes&                cnodes )
{
    if ( _mpi_comm_eff )
    {
        _mpi_comm_eff->applyCnode( cnodes );
    }
}




void
BSPOPHybridOMPCommunicationEfficiencyTest::applyCnode( const cube::list_of_cnodes& cnodes,
                                                       const bool                    )
{
    auto par_comm_task_result = std::async( std::launch::async, par_comm_task_full_, par_comm_eff, cnodes );
    auto mpi_comm_task_result = std::async( std::launch::async, mpi_comm_task_full_, mpi_comm_eff, cnodes );

    par_comm_task_result.get();
    mpi_comm_task_result.get();
    calculate();
}





const std::string&
BSPOPHybridOMPCommunicationEfficiencyTest::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
BSPOPHybridOMPCommunicationEfficiencyTest::isActive() const
{
    return par_comm_eff != nullptr &&
           mpi_comm_eff != nullptr &&
           (
        ( par_comm_eff->isActive() )  || ( mpi_comm_eff->isActive() ) )
    ;
};

bool
BSPOPHybridOMPCommunicationEfficiencyTest::isIssue() const
{
    return false;
};

void
BSPOPHybridOMPCommunicationEfficiencyTest::adjustForTest( cube::CubeProxy* cube ) const
{
    ( void )cube;
}
