/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_MPI_TRANSFER_TEST_H
#define CUBELIB_BSPOP_HYBRID_MPI_TRANSFER_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace bscanalysis
{
class BSPOPHybridMPITransferTest : public popcalculation::PerformanceTest
{
private:
    cube::Metric* max_total_time_ideal;
    cube::Metric* max_total_time;

    cube::list_of_metrics lmax_total_time_ideal;

    void
    add_max_total_time_ideal( cube::CubeProxy* ) const;

    void
    add_max_total_time( cube::CubeProxy* ) const;

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false );


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Transfer Efficiency (TE) quantifies the performance loss caused by data transfer operations.\n"
            "It is calculated using the formula:\n"
            "\tTE = [maximum(runtime on ideal network across processes)] / [maximum(measured runtime across processes)]\n\n"
            "The ideal network runtime represents the execution time excluding Scalasca-identified waiting periods\n"
            "and all MPI input/output operations.";

        std::string not_active_text =
            "The Transfer Efficiency metric requires pre-detection of MPI wait states in the measurement data.\n"
            "It is therefore only available for analysis of Scalasca trace results, specifically from files such as\n"
            "scout.cubex or trace.cubex generated by the Scalasca tool suite.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    BSPOPHybridMPITransferTest( cube::CubeProxy* );

    virtual
    ~BSPOPHybridMPITransferTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // BSPOPHybrid_IMBALANCE_TEST_H
