/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_MPI_SERIALISATION_TEST_H
#define CUBELIB_BSPOP_HYBRID_MPI_SERIALISATION_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace bscanalysis
{
class BSPOPHybridMPISerialisationTest : public popcalculation::PerformanceTest
{
private:
    cube::Metric*         max_omp_serial_comp_time;
    cube::Metric*         max_total_time_ideal;
    cube::list_of_metrics lmax_omp_serial_comp_time;

    void
    add_max_total_time_ideal_hyb( cube::CubeProxy* ) const;

    void
    add_transfer_time_mpi( cube::CubeProxy* ) const;

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Serialization Efficiency (SerE) quantifies inefficiencies caused by idle periods during communication,\n"
            "specifically when no data transfer occurs. It is calculated as:\n"
            "\tSerE = max(computation time / ideal runtime) across all processes\n\n"
            "The ideal runtime represents the execution time without Scalasca-detected waiting periods and MPI I/O operations.";

        std::string not_active_text =
            "Serialization Efficiency is only available when MPI wait states are properly detected and measured.\n"
            "This metric can exclusively be computed from Scalasca trace analysis results,\n"
            "such as those found in scout.cubex or trace.cubex files generated by Scalasca tools.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    BSPOPHybridMPISerialisationTest( cube::CubeProxy* );

    virtual
    ~BSPOPHybridMPISerialisationTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // BSPOPHybrid_IMBALANCE_TEST_H
