/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_AUDIT_PERFORMANCE_ANALYSIS_H
#define CUBELIB_BSPOP_HYBRID_AUDIT_PERFORMANCE_ANALYSIS_H

#include <string>
#include "Cube.h"


#include "PerformanceAnalysis.h"
#include "PerformanceTest.h"


#include "BSPOPHybridCommunicationEfficiencyTest.h"
#include "BSPOPHybridLoadBalanceTest.h"
#include "BSPOPHybridMPICommunicationEfficiencyTest.h"
#include "BSPOPHybridMPILoadBalanceTest.h"
#include "BSPOPHybridMPIParallelEfficiencyTest.h"
#include "BSPOPHybridMPISerialisationTest.h"
#include "BSPOPHybridMPITransferTest.h"
#include "BSPOPHybridOMPCommunicationEfficiencyTest.h"
#include "BSPOPHybridOMPLoadBalanceEfficiencyTest.h"
#include "BSPOPHybridOMPParallelEfficiencyTest.h"
#include "BSPOPHybridParallelEfficiencyTest.h"
#include "POPComputationTimeTest.h"
#include "POPGPUComputationTimeTest.h"
#include "POPIPCTest.h"
#include "POPNoWaitINSTest.h"
#include "POPStalledResourcesTest.h"
#include "POPWallTimeTest.h"
#include "POPIOEfficiencyTest.h"
#include "POPMpiIOTimeTest.h"
#include "POPPosixIOTimeTest.h"

#include "POPGPUParallelTest.h"
#include "POPGPUCommunicationEfficiencyTest.h"
#include "POPGPUImbalanceTest.h"


namespace bscanalysis
{
class BSPOPHybridAuditPerformanceAnalysis : public popcalculation::PerformanceAnalysis
{
protected:

    popcalculation::POPStalledResourcesTest* stalled_resources;
    popcalculation::POPNoWaitINSTest*        no_wait_ins;
    popcalculation::POPIPCTest*              ipc;
    popcalculation::POPWallTimeTest*         wall;
    popcalculation::POPComputationTime*      comp;
    popcalculation::POPGPUComputationTime*   gpu_comp;
    popcalculation::POPPosixIOTime*          posix_io;
    popcalculation::POPMpiIOTime*            mpi_io;
    popcalculation::POPIOEfficiencyTest*     io_eff;

    BSPOPHybridMPITransferTest*                mpi_transfer_eff;
    BSPOPHybridMPISerialisationTest*           mpi_ser_eff;
    BSPOPHybridMPICommunicationEfficiencyTest* mpi_comm_eff;
    BSPOPHybridMPILoadBalanceTest*             mpi_lb_eff;
    BSPOPHybridMPIParallelEfficiencyTest*      mpi_pareff;

    BSPOPHybridOMPCommunicationEfficiencyTest* omp_comm_eff;
    BSPOPHybridOMPLoadBalanceEfficiencyTest*   omp_lb_eff;
    BSPOPHybridOMPParallelEfficiencyTest*      omp_par_eff;

    BSPOPHybridCommunicationEfficiencyTest* hyb_comm_eff;
    BSPOPHybridLoadBalanceTest*             hyb_lb_eff;
    BSPOPHybridParallelEfficiencyTest*      hyb_par_eff;

    popcalculation::POPGPUCommunicationEfficiencyTest* gpu_comm_eff;
    popcalculation::POPGPUImbalanceTest*               gpu_lb_eff;
    popcalculation::POPGPUParallelEfficiencyTest*      gpu_par_eff;


    double max_ipc;

public:
    BSPOPHybridAuditPerformanceAnalysis( cube::CubeProxy* _cube );

    virtual
    ~BSPOPHybridAuditPerformanceAnalysis();


    virtual
    inline
    std::string
    name() const
    {
        return "BSC Hybrid Assessment";
    }

    // returns list of tests, which can be calculated independentely in sepaate tasks
    virtual
    std::list<popcalculation::PerformanceTest*>
    getAllTestsForCalculation();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getPOPTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getGPUTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getIOTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getAdditionalTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getControlTests();


    virtual
    std::string
    getAnchorHowToMeasure();

// ------ overview tests ---------

    virtual
    bool
    isActive() const;
};
};

#endif // ADVISER_RATING_WIDGET_H
