/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <string>
#include "PerformanceTest_incl.h"

std::string popcalculation::cubepl_time_init_str =
    "            {\n"
    "                // Generic masks\n"
    "                global(execution);\n"
    "                global(overhead);\n"
    "                global(idle_gpus);\n"
    "                global(without_wait_state);\n"
    "\n"
    "                 global(includesMPI);\n"
    "                // MPI-specific masks\n"
    "                global(mpi);\n"
    "                global(mpi_mgmt_startup);\n"
    "                global(mpi_mgmt_comm);\n"
    "                global(mpi_mgmt_file);\n"
    "                global(mpi_mgmt_win);\n"
    "                global(mpi_sync_collective);\n"
    "                global(mpi_sync_rma_active);\n"
    "                global(mpi_sync_rma_passive);\n"
    "                global(mpi_comm_p2p);\n"
    "                global(mpi_comm_collective);\n"
    "                global(mpi_comm_rma);\n"
    "                global(mpi_file_individual);\n"
    "                global(mpi_file_collective);\n"
    "                global(mpi_file_iops);\n"
    "                global(mpi_file_irops);\n"
    "                global(mpi_file_iwops);\n"
    "                global(mpi_file_cops);\n"
    "                global(mpi_file_crops);\n"
    "                global(mpi_file_cwops);\n"
    "                global(mpi_request_handling);\n"
    "                global(mpi_request_start);\n"
    "                global(mpi_request_completion);\n"
    "\n"
    "                global(includesSHMEM);\n"
    "                // SHMEM-specific masks\n"
    "                global(shmem);\n"
    "                global(shmem_mgmt_initfini);\n"
    "                global(shmem_mgmt_activesets);\n"
    "                global(shmem_mgmt_query);\n"
    "                global(shmem_comm_rma);\n"
    "                global(shmem_comm_atomic);\n"
    "                global(shmem_comm_coll);\n"
    "                global(shmem_sync_rma);\n"
    "                global(shmem_sync_coll);\n"
    "                global(shmem_sync_locking);\n"
    "                global(shmem_memory_mgmt);\n"
    "                global(shmem_memory_ordering);\n"
    "                global(shmem_event);\n"
    "                global(shmem_cache);\n"
    "\n"
    "                global(includesOpenMP);\n"
    "                global(includesOpenMPTarget);\n"
    "                global(omp);\n"
    "                // OpenMP-specific masks\n"
    "                global(omp_sync_ebarrier);\n"
    "                global(omp_sync_ibarrier);\n"
    "                global(omp_sync_critical);\n"
    "                global(omp_sync_lock_api);\n"
    "                global(omp_sync_ordered);\n"
    "                global(omp_sync_taskwait);\n"
    "                global(omp_flush);\n"
    "                global(omp_target);\n"
    "\n"
    "                 global(includesPthread);\n"
    "                // Pthread-specific masks\n"
    "                global(pthread);\n"
    "                global(pthread_mgmt);\n"
    "                global(pthread_sync_mutex);\n"
    "                global(pthread_sync_condition);\n"
    "\n"
    "                // OpenACC-specific masks\n"
    "                 global(includesOpenACC);\n"
    "                global(openacc);\n"
    "                global(openacc_setup);\n"
    "                global(openacc_comm);\n"
    "                global(openacc_sync);\n"
    "                global(openacc_kernel_launches);\n"
    "                global(openacc_kernel_executions);\n"
    "\n"
    "                // OpenCL-specific masks\n"
    "                 global(includesOpenCL);\n"
    "                global(opencl);\n"
    "                global(opencl_setup);\n"
    "                global(opencl_comm);\n"
    "                global(opencl_sync);\n"
    "                global(opencl_kernel_launches);\n"
    "                global(opencl_kernel_executions);\n"
    "\n"
    "                // CUDA-specific masks\n"
    "                global(includesCUDA);\n"
    "                global(includesIdleGPUs);\n"
    "                global(cuda);\n"
    "                global(cuda_setup);\n"
    "                global(cuda_comm);\n"
    "                global(cuda_sync);\n"
    "                global(cuda_kernel_launches);\n"
    "                global(cuda_kernel_executions);\n"
    "\n"
    "                // HIP-specific masks\n"
    "                global(includesHIP);\n"
    "                global(hip);\n"
    "                global(hip_stream);\n"
    "                global(hip_malloc);\n"
    "                global(hip_memcpy);\n"
    "                global(hip_sync);\n"
    "                global(hip_kernel_launches);\n"
    "                global(hip_kernel_executions);\n"
    "\n"
    "                // File I/O-specific masks\n"
    "                global(includesFILEIO);\n"
    "                global(fileio);\n"
    "                global(fileio_meta);\n"
    "                global(fileio_reading);\n"
    "                global(fileio_writing);\n"
    "\n"
    "                // Wrapped libraries masks\n"
    "                global(includesLIBWRAP);\n"
    "                global(libwrap);\n"
    "\n"
    "                global(includesMEMORY);\n"
    "\n"
    "                //--- Paradigm/feature flags --------------------------------\n"
    "                // These flags indicate which of the supported parallel\n"
    "                // programming paradigms and/or features are used in the\n"
    "                // experiment to later enable/disable the corresponding\n"
    "                // metric subtrees.\n"
    "\n"
    "                ${includesMPI}      = 0;\n"
    "                ${includesSHMEM}    = 0;\n"
    "                ${includesOpenMP}   = 0;\n"
    "                ${includesOpenMPTarget}   = 0;\n"
    "                ${includesPthread}  = 0;\n"
    "                ${includesOpenACC}  = 0;\n"
    "                ${includesOpenCL}   = 0;\n"
    "                ${includesCUDA}     = 0;\n"
    "                ${includesIdleGPUs} = 0;\n"
    "                ${includesHIP}      = 0;\n"
    "                ${includesLIBWRAP}  = 0;\n"
    "                ${includesFILEIO}   = 0;\n"
    "                ${includesMEMORY}   = 0;\n"
    "\n"
    "\n"
    "                //--- Callpath categorization -------------------------------\n"
    "                // Each callpath is categorized by type and its global type\n"
    "                // mask entry is set accordingly.\n"
    "\n"
    "                ${i} = 0;\n"
    "                while ( ${i} < ${cube::#callpaths} )\n"
    "                {\n"
    "                    // Default: all callpaths are considered to be execution\n"
    "                    ${execution}[${i}] = 1;\n"
    "                    ${without_wait_state}[${i}] = 1;\n"
    "                    ${regionid}        = ${cube::callpath::calleeid}[${i}];\n"
    "\n"
    "                    if ( ${cube::region::mangled_name}[${regionid}] eq \"\" )\n"
    "                    {\n"
    "                        ${name} = ${cube::region::name}[${regionid}];\n"
    "                    }\n"
    "                    else\n"
    "                    {\n"
    "                        ${name} = ${cube::region::mangled_name}[${regionid}];\n"
    "                    };\n"
    "\n"
    "                    ${paradigm}   = ${cube::region::paradigm}[${regionid}];\n"
    "                    ${role}       = ${cube::region::role}[${regionid}];\n"
    "                    ${sourcefile} = ${cube::region::mod}[${regionid}];\n"
    "\n"
    "                    //--- MPI-specific categorization ---\n"
    "                    if ( ${paradigm} eq \"mpi\" )\n"
    "                    {\n"
    "                        ${includesMPI} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "                        ${mpi}[${i}]   = 1;\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_(Init(_thread|ialized){0,1}|Finalize(d){0,1})$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_startup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_(Cart_(coords|create|get|map|rank|shift|sub)|Cartdim_get|Comm_(accept|compare|connect|create(_group|_keyval){0,1}|delete_attr|disconnect|dup(_with_info){0,1}|free(_keyval){0,1}|get_(attr|info|name|parent)|group|idup|join|rank|remote_(group|size)|set_(attr|info|name)|size|spawn(_multiple){0,1}|split(_type){0,1}|test_inter)|Dims_create|Dist_graph_(create(_adjacent){0,1}|neighbors(_count){0,1})|Graph_(create|get|map|neighbors(_count){0,1})|Graphdims_get|Intercomm_(create|merge)|Topo_test|(Close|Open)_port|(Lookup|Publish|Unpublish)_name)$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_File_(close|delete|get_(amode|atomicity|byte_offset|group|info|position(_shared){0,1}|size|type_extent|view)|open|preallocate|seek(_shared){0,1}|set_(atomicity|info|size|view)|sync)$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_file}[${i}] = 1;\n"
    "\n"
    "                            if ( ${name} =~ /(delete|get|seek)/ )\n"
    "                            {\n"
    "                                ${mpi_file_iops}[${i}] = 1;\n"
    "                            }\n"
    "                            else\n"
    "                            {\n"
    "                                ${mpi_file_cops}[${i}] = 1;\n"
    "                            };\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_Win_(allocate(_shared){0,1}|attach|create(_dynamic|_keyval){0,1}|delete_attr|detach|free(_keyval){0,1}|get_(attr|group|info|name)|set_(attr|info|name)|shared_query)$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_win}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} eq \"barrier\" )\n"
    "                        {\n"
    "                            ${mpi_sync_collective}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_Win_(complete|fence|post|start|test|wait)$/ )\n"
    "                        {\n"
    "                            ${mpi_sync_rma_active}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_Win_((flush(_local){0,1}|lock|unlock)(_all){0,1}|sync)$/ )\n"
    "                        {\n"
    "                            ${mpi_sync_rma_passive}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} eq \"point2point\" )\n"
    "                        {\n"
    "                            ${mpi_comm_p2p}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_Test_cancelled$/ )\n"
    "                        {\n"
    "                            ${mpi_request_handling}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_Start(all){0,1}$/ )\n"
    "                        {\n"
    "                            ${mpi_request_handling}[${i}] = 1;\n"
    "                            ${mpi_request_start}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ( ${name} =~ /^MPI_(Test|Wait)(all|any|some){0,1}$/ )\n"
    "                             or\n"
    "                             ( ${name} =~ /^MPI_Cancel$/ )\n"
    "                             or\n"
    "                             ( ${name} =~ /^MPI_Request_free$/ )\n"
    "                             or\n"
    "                             ( ${name} =~ /^MPI_Request_get_status$/ ) )\n"
    "                        {\n"
    "                            ${mpi_request_handling}[${i}] = 1;\n"
    "                            ${mpi_request_completion}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} =~ /^(one2all|all2one|all2all|other collective)$/ )\n"
    "                        {\n"
    "                            ${mpi_comm_collective}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} =~ /^(rma|atomic)$/ )\n"
    "                        {\n"
    "                            ${mpi_comm_rma}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_File_i{0,1}(read|write)(_at|_shared){0,1}$/ )\n"
    "                        {\n"
    "                            ${mpi_file_individual}[${i}] = 1;\n"
    "                            ${mpi_file_iops}[${i}]       = 1;\n"
    "\n"
    "                            if ( ${name} =~ /read/ )\n"
    "                            {\n"
    "                                ${mpi_file_irops}[${i}] = 1;\n"
    "                            }\n"
    "                            else\n"
    "                            {\n"
    "                                ${mpi_file_iwops}[${i}] = 1;\n"
    "                            };\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^MPI_File_((iread|iwrite)_(all|at_all)|(read|write)_(all|at_all|ordered)(_begin|_end){0,1})$/ )\n"
    "                        {\n"
    "                            ${mpi_file_collective}[${i}] = 1;\n"
    "                            ${mpi_file_cops}[${i}]       = 1;\n"
    "\n"
    "                            if ( ${name} =~ /read/ )\n"
    "                            {\n"
    "                                ${mpi_file_crops}[${i}] = 1;\n"
    "                            }\n"
    "                            else\n"
    "                            {\n"
    "                                ${mpi_file_cwops}[${i}] = 1;\n"
    "                            };\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- SHMEM-specific categorization ---\n"
    "                    elseif ( ${paradigm} eq \"shmem\" )\n"
    "                    {\n"
    "                        ${includesSHMEM} = 1;\n"
    "                        ${shmem}[${i}] = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        if ( ${name} =~ /^(shmem_init(_thread){0,1}|start_pes|shmem_finalize)$/ )\n"
    "                        {\n"
    "                            ${shmem_mgmt_initfini}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${name} =~ /^((shmem_|_){0,1}(my_pe|num_pes)|shmem_team_(split|create_strided|free|npes|mype|translate_pe))$/ )\n"
    "                        {\n"
    "                            ${shmem_mgmt_activesets}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${name} =~ /^(shmem_((pe|adr)_accessible|ptr))$/ )\n"
    "                        {\n"
    "                            ${shmem_mgmt_query}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} eq \"rma\" )\n"
    "                        {\n"
    "                            ${shmem_comm_rma}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${role} eq \"atomic\" )\n"
    "                        {\n"
    "                            ${shmem_comm_atomic}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${role} =~ /^(one2all|all2one|all2all|other collective)$/ )\n"
    "                        {\n"
    "                            ${shmem_comm_coll}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^(shmem(short|int|long|longlong){0,1}_wait(_until){0,1})$/ )\n"
    "                        {\n"
    "                            ${shmem_sync_rma}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${role} eq \"barrier\" )\n"
    "                        {\n"
    "                            ${shmem_sync_coll}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${name} =~ /^(shmem_(set|test|clear)_lock)$/ )\n"
    "                        {\n"
    "                            ${shmem_sync_locking}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} =~ /^((de|re){0,1}allocate)$/ )\n"
    "                        {\n"
    "                            ${shmem_memory_mgmt}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${name} =~ /^(shmem_(fence|quiet))$/ )\n"
    "                        {\n"
    "                            ${shmem_memory_ordering}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^(shmem_(set|test|clear|wait)_event)$/ )\n"
    "                        {\n"
    "                            ${shmem_event}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^(shmem_((clear|set)_cache(_line){0,1}_inv|udcflush(_line){0,1}))$/ )\n"
    "                        {\n"
    "                            ${shmem_cache}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                    }\n"
    "\n"
    "                    //--- OpenMP-specific categorization ---\n"
    "                    elseif ( ${paradigm} eq \"openmp\" )\n"
    "                    {\n"
    "                        ${includesOpenMP} = 1;\n"
    "\n"
    "                        if ( ${role} eq \"barrier\" )\n"
    "                        {\n"
    "                            ${omp_sync_ebarrier}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} eq \"implicit barrier\" )\n"
    "                        {\n"
    "                            ${omp_sync_ibarrier}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} =~ /^(atomic|critical)$/ )\n"
    "                        {\n"
    "                            ${omp_sync_critical}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^omp_(destroy|init|set|test|unset)(_nest){0,1}_lock$/ )\n"
    "                        {\n"
    "                            ${omp_sync_lock_api}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} eq \"ordered\" )\n"
    "                        {\n"
    "                            ${omp_sync_ordered}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} eq \"taskwait\" )\n"
    "                        {\n"
    "                            ${omp_sync_taskwait}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${role} eq \"flush\" )\n"
    "                        {\n"
    "                            ${omp_flush}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "                    }\n"
    "                    //--- OpenMP-Target-specific categorization ---\n"
    "                    elseif ( ${paradigm} eq \"openmp target\" )\n"
    "                    {\n"
    "                        ${includesOpenMPTarget} = 1;\n"
    "                        ${includesOpenMP} = 1;\n"
    "\n"
    "                        if ( ${role} eq \"kernel\" )\n"
    "                        {\n"
    "                            ${omp_target}[${i}] = 1;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- Pthread-specific categorization ---\n"
    "                    elseif ( ${paradigm} eq \"pthread\" )\n"
    "                    {\n"
    "                        ${includesPthread} = 1;\n"
    "\n"
    "                        if ( ${name} =~ /^pthread_(cancel|create|detach|exit|join)$/ )\n"
    "                        {\n"
    "                            ${pthread_mgmt}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^pthread_mutex_(destroy|init|lock|trylock|unlock)$/ )\n"
    "                        {\n"
    "                            ${pthread_sync_mutex}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^pthread_cond_(broadcast|destroy|init|signal|timedwait|wait)$/ )\n"
    "                        {\n"
    "                            ${pthread_sync_condition}[${i}] = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- OpenACC-specific categorization ---\n"
    "                    elseif ( ${paradigm} eq \"openacc\" )\n"
    "                    {\n"
    "                        ${includesOpenACC} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        ${openacc}[${i}] = 1;\n"
    "\n"
    "                        if ( ${name} =~ /^acc_(init|shutdown)(@.*)?$/ )\n"
    "                        {\n"
    "                            ${openacc_setup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^acc_(upload|download)(@.*)?$/ )\n"
    "                        {\n"
    "                            ${openacc_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^acc_wait(@.*)?$/ )\n"
    "                        {\n"
    "                            ${openacc_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^acc_launch_kernel(@.*)?$/ )\n"
    "                        {\n"
    "                            ${openacc_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${sourcefile} seq \"OPENACC_KERNEL\" )\n"
    "                        {\n"
    "                            ${openacc_kernel_executions}[${i}] = 1;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- OpenCL-specific categorization ---\n"
    "                    elseif ( ${paradigm} eq \"opencl\" )\n"
    "                    {\n"
    "                        ${includesOpenCL} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        if ( not ( ${name} eq \"BUFFER FLUSH\" ) )\n"
    "                        {\n"
    "                            ${opencl}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^cl(GetPlatformIDs|GetPlatformInfo|GetDeviceIDs|GetDeviceInfo|CreateSubDevices|RetainDevice|ReleaseDevice|CreateContext|CreateContextFromType|RetainContext|ReleaseContext|GetContextInfo|CreateProgramWithSource|CreateProgramWithBinary|RetainProgram|ReleaseProgram|GetProgramInfo|GetProgramBuildInfo|CreateKernelsInProgram|CreateProgramWithBuiltInKernels|BuildProgram|CompileProgram|LinkProgram|CreateKernel|RetainKernel|ReleaseKernel|GetEventInfo|RetainEvent|ReleaseEvent|GetEventProfilingInfo|CreateUserEvent|SetUserEventStatus|SetEventCallback|CreateCommandQueue|CreateCommandQueueWithProperties|RetainCommandQueue|ReleaseCommandQueue|GetCommandQueueInfo|SetCommandQueueProperty|GetKernelInfo|GetKernelWorkGroupInfo|GetKernelArgInfo|Flush|UnloadCompiler|UnloadPlatformCompiler|GetExtensionFunctionAddress|GetExtensionFunctionAddressForPlatform|SetMemObjectDestructorCallback|GetMemObjectInfo|GetPipeInfo|GetSupportedImageFormats|GetImageInfo|GetSamplerInfo|CreateProgramWithIL|GetKernelSubGroupInfo|GetHostTimer|GetDeviceAndHostTimer|CloneKernel|SetDefaultDeviceCommandQueue|SetProgramReleaseCallback|SetProgramSpecializationConstant)$/ )\n"
    "                        {\n"
    "                            ${opencl_setup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^cl(CreateBuffer|CreateSubBuffer|EnqueueReadBuffer|EnqueueReadBufferRect|EnqueueWriteBuffer|EnqueueWriteBufferRect|EnqueueFillBuffer|EnqueueCopyBuffer|EnqueueCopyBufferRect|EnqueueMapBuffer|EnqueueUnmapMemObject|EnqueueMigrateMemObjects|CreatePipe|SVMAlloc|SVMFree|EnqueueSVMFree|EnqueueSVMMemcpy|EnqueueSVMMemFill|EnqueueSVMMap|EnqueueSVMUnmap|CreateImage|CreateImage2D|CreateImage3D|EnqueueReadImage|EnqueueWriteImage|EnqueueCopyImage|EnqueueCopyImageToBuffer|EnqueueCopyBufferToImage|EnqueueMapImage|EnqueueFillImage|CreateSamplerWithProperties|CreateSampler|ReleaseSampler|RetainSampler|RetainMemObject|ReleaseMemObject|EnqueueSVMMigrateMem)$/ )\n"
    "                        {\n"
    "                            ${opencl_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^cl(Finish|WaitForEvents|EnqueueWaitForEvents|EnqueueBarrier|EnqueueMarker|EnqueueMarkerWithWaitList|EnqueueBarrierWithWaitList)$/ )\n"
    "                        {\n"
    "                            ${opencl_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} eq \"WAIT FOR COMMAND QUEUE\" )\n"
    "                        {\n"
    "                            ${opencl_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^cl(SetKernelArg|SetKernelArgSVMPointer|SetKernelExecInfo|EnqueueNDRangeKernel|EnqueueTask|EnqueueNativeKernel)$/ )\n"
    "                        {\n"
    "                            ${opencl_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${sourcefile} seq \"OPENCL_KERNEL\" )\n"
    "                        {\n"
    "                            ${opencl_kernel_executions}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} eq \"BUFFER FLUSH\" )\n"
    "                        {\n"
    "                            ${opencl}[${i}]    = 0;\n"
    "                            ${execution}[${i}] = 0;\n"
    "                            ${overhead}[${i}]  = 1;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- CUDA-specific classification ---\n"
    "                    elseif ( ${paradigm} eq \"cuda\" )\n"
    "                    {\n"
    "                        ${includesCUDA} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        if ( not ( ${name} eq \"BUFFER FLUSH\" ) )\n"
    "                        {\n"
    "                            ${cuda}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Runtime API: general CUDA management, e.g. device, stream, event, execution, occupancy\n"
    "                        if ( ${name} =~ /^cuda(ChooseDevice|DeviceGetAttribute|DeviceGetByPCIBusId|DeviceGetCacheConfig|DeviceGetLimit|DeviceGetPCIBusId|DeviceGetSharedMemConfig|DeviceGetStreamPriorityRange|DeviceReset|DeviceSetCacheConfig|DeviceSetLimit|DeviceSetSharedMemConfig|GetDevice|GetDeviceCount|GetDeviceFlags|GetDeviceProperties|SetDevice|SetDeviceFlags|SetValidDevices|ThreadExit|ThreadGetCacheConfig|ThreadGetLimit|ThreadSetCacheConfig|ThreadSetLimit|StreamCreate|StreamCreateWithFlags|StreamCreateWithPriority|StreamDestroy|EventCreate|EventCreateWithFlags|EventDestroy|FuncSetCacheConfig|CtxResetPersistingL2Cache|DeviceGetNvSciSyncAttributes|DeviceGetP2PAttribute|DeviceGetTexture1DLinearMaxWidth|EventElapsedTime|EventQuery|EventRecord|EventRecordWithFlags|FuncGetAttributes|FuncSetAttribute|FuncSetSharedMemConfig|GetParameterBuffer|IpcCloseMemHandle|IpcGetEventHandle|IpcGetMemHandle|IpcOpenEventHandle|IpcOpenMemHandle|OccupancyAvailableDynamicSMemPerBlock|OccupancyMaxActiveBlocksPerMultiprocessor|OccupancyMaxActiveBlocksPerMultiprocessorWithFlags|SetDoubleForDevice|SetDoubleForHost|StreamAddCallback|StreamAttachMemAsync|StreamBeginCapture|StreamCopyAttributes|StreamEndCapture|StreamGetAttribute|StreamGetCaptureInfo|StreamGetFlags|StreamGetPriority|StreamIsCapturing|StreamQuery|StreamSetAttribute|ThreadExchangeStreamCaptureMode)$/ )\n"
    "                        {\n"
    "                            ${cuda_setup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Runtime API: memory management (memset functions considered in kernel launch section)\n"
    "                        if ( ${name} =~ /^cuda(Free|FreeArray|FreeHost|FreeMipmappedArray|HostAlloc|Malloc|Malloc3D|Malloc3DArray|MallocArray|MallocHost|MallocManaged|MallocMipmappedArray|MallocPitch|Memcpy|Memcpy2D|Memcpy2DArrayToArray|Memcpy2DAsync|Memcpy2DFromArray|Memcpy2DFromArrayAsync|Memcpy2DToArray|Memcpy2DToArrayAsync|Memcpy3D|Memcpy3DAsync|MemcpyPeer|MemcpyPeerAsync|MemcpyArrayToArray|MemcpyAsync|MemcpyFromArray|MemcpyFromArrayAsync|MemcpyFromSymbol|MemcpyFromSymbolAsync|MemcpyToArray|MemcpyToArrayAsync|MemcpyToSymbol|MemcpyToSymbolAsync|ArrayGetInfo|ArrayGetSparseProperties|GetMipmappedArrayLevel|GetSymbolAddress|GetSymbolSize|HostGetDevicePointer|HostGetFlags|HostRegister|HostUnregister|MemAdvise|MemGetInfo|MemPrefetchAsync|MemRangeGetAttribute|MemRangeGetAttributes|Memcpy3DPeer|Memcpy3DPeerAsync|MipmappedArrayGetSparseProperties|PointerGetAttributes)$/ )\n"
    "                        {\n"
    "                            ${cuda_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Runtime API: synchronization\n"
    "                        if ( ${name} =~ /^cuda(StreamWaitEvent|StreamSynchronize|EventSynchronize|DeviceSynchronize|ThreadSynchronize)$/ )\n"
    "                        {\n"
    "                            ${cuda_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Runtime API: kernel launches\n"
    "                        if ( ${name} =~ /^cuda(LaunchKernel|Launch|GetParameterBufferV2|Memset|Memset2D|Memset2DAsync|Memset3D|Memset3DAsync|MemsetAsync|LaunchCooperativeKernel|LaunchCooperativeKernelMultiDevice|LaunchHostFunc)$/ )\n"
    "                        {\n"
    "                            ${cuda_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Driver API: general CUDA management, e.g. initialization, version, device,\n"
    "                        // primary context, context, streams, events, occupancy\n"
    "                        if ( ${name} =~ /^cu(Init|DeviceGet|DeviceGetAttribute|DeviceGetCount|DeviceGetName|DeviceTotalMem|DeviceComputeCapability|DeviceGetProperties|DevicePrimaryCtxGetState|DevicePrimaryCtxRelease|DevicePrimaryCtxReset|DevicePrimaryCtxRetain|DevicePrimaryCtxSetFlags|CtxCreate|CtxDestroy|CtxGetApiVersion|CtxGetCacheConfig|CtxGetCurrent|CtxGetDevice|CtxGetFlags|CtxGetLimit|CtxGetSharedMemConfig|CtxGetStreamPriorityRange|CtxPopCurrent|CtxPushCurrent|CtxSetCacheConfig|CtxSetCurrent|CtxSetLimit|CtxSetSharedMemConfig|CtxAttach|CtxDetach|LinkCreate|LinkDestroy|EventCreate|EventDestroy|StreamCreate|StreamCreateWithPriority|StreamDestroy|CtxResetPersistingL2Cache|DeviceGetLuid|DeviceGetNvSciSyncAttributes|DeviceGetTexture1DLinearMaxWidth|DeviceGetUuid|DriverGetVersion|EventElapsedTime|EventQuery|EventRecord|EventRecordWithFlagsFuncGetAttribute|FuncSetAttribute|FuncSetBlockShape|FuncSetCacheConfig|FuncSetSharedMemConfig|FuncSetSharedSize|LinkAddData|LinkAddFile|LinkComplete|ModuleGetFunction|ModuleGetGlobal|ModuleGetSurfRef|ModuleGetTexRef|ModuleLoad|ModuleLoadData|ModuleLoadDataEx|ModuleLoadFatBinary|ModuleUnload|OccupancyAvailableDynamicSMemPerBlock|OccupancyMaxActiveBlocksPerMultiprocessor|OccupancyMaxActiveBlocksPerMultiprocessorWithFlags|OccupancyMaxPotentialBlockSize|OccupancyMaxPotentialBlockSizeWithFlags|ParamSetSize|ParamSetTexRef|ParamSetf|ParamSeti|ParamSetv|StreamAddCallback|StreamAttachMemAsync|StreamBeginCapture|StreamCopyAttributes|StreamEndCapture|StreamGetAttribute|StreamGetCaptureInfo|StreamGetCtx|StreamGetFlags|StreamGetPriority|StreamIsCapturing|StreamQuery|StreamSetAttribute|ThreadExchangeStreamCaptureMode)(_v[0-9]+)?$/ )\n"
    "                        {\n"
    "                            ${cuda_setup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Driver API: memory management, incl. virtual memory, unified addressing\n"
    "                        // (memset functions considered in kernel launch section)\n"
    "                        if ( ${name} =~ /^cu(Array3DCreate|ArrayCreate|ArrayDestroy|MemAlloc|MemAllocHost|MemAllocManaged|MemAllocPitch|Memcpy|Memcpy2D|Memcpy2DAsync|Memcpy2DUnaligned|Memcpy3D|Memcpy3DAsync|Memcpy3DPeer|Memcpy3DPeerAsync|MemcpyAsync|MemcpyAtoA|MemcpyAtoD|MemcpyAtoH|MemcpyAtoHAsync|MemcpyDtoA|MemcpyDtoD|MemcpyDtoDAsync|MemcpyDtoH|MemcpyDtoHAsync|MemcpyHtoA|MemcpyHtoAAsync|MemcpyHtoD|MemcpyHtoDAsync|MemcpyPeer|MemcpyPeerAsync|MipmappedArrayCreate|MipmappedArrayDestroy|MemFree|MemFreeHost|MemHostAlloc|Array3DGetDescriptor|ArrayGetDescriptor|ArrayGetSparseProperties|DeviceGetByPCIBusId|DeviceGetPCIBusId|IpcCloseMemHandle|IpcGetEventHandle|IpcGetMemHandle|IpcOpenEventHandle|IpcOpenMemHandle|MemAddressFree|MemAddressReserve|MemAdvise|MemCreate|MemExportToShareableHandle|MemGetAccess|MemGetAddressRange|MemGetAllocationGranularity|MemGetAllocationPropertiesFromHandle|MemGetInfo|MemHostGetDevicePointer|MemHostGetFlags|MemHostRegister|MemHostUnregister|MemImportFromShareableHandle|MemMap|MemMapArrayAsync|MemPrefetchAsync|MemRangeGetAttribute|MemRangeGetAttributes|MemRelease|MemRetainAllocationHandle|MemSetAccess|MemUnmap|MipmappedArrayGetLevel|MipmappedArrayGetSparseProperties|PointerGetAttribute|PointerGetAttributes|PointerSetAttribute)(_v[0-9]+)?$/ )\n"
    "                        {\n"
    "                            ${cuda_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Driver API: synchronization\n"
    "                        if ( ${name} =~ /^cu(CtxSynchronize|StreamWaitEvent|StreamSynchronize|EventSynchronize)(_v[0-9]+)?$/ )\n"
    "                        {\n"
    "                            ${cuda_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // CUDA Driver API: kernel launches\n"
    "                        if ( ${name} =~ /^cu(LaunchKernel|Launch|LaunchGrid|LaunchGridAsync|MemsetD16|MemsetD16Async|MemsetD2D16|MemsetD2D16Async|MemsetD2D32|MemsetD2D32Async|MemsetD2D8|MemsetD2D8Async|MemsetD32|MemsetD32Async|MemsetD8|MemsetD8Async|LaunchCooperativeKernel|LaunchCooperativeKernelMultiDevice|LaunchHostFunc)(_v[0-9]+)?$/ )\n"
    "                        {\n"
    "                            ${cuda_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} eq \"DEVICE SYNCHRONIZE\" )\n"
    "                        {\n"
    "                            ${cuda_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${sourcefile} seq \"CUDA_KERNEL\" )\n"
    "                        {\n"
    "                            ${cuda_kernel_executions}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} eq \"BUFFER FLUSH\" )\n"
    "                        {\n"
    "                            ${cuda}[${i}]      = 0;\n"
    "                            ${execution}[${i}] = 0;\n"
    "                            ${overhead}[${i}]  = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} eq \"COMPUTE IDLE\" )\n"
    "                        {\n"
    "                            ${includesIdleGPUs} = 1;\n"
    "                            ${cuda}[${i}]       = 0;\n"
    "                            ${execution}[${i}]  = 0;\n"
    "                            ${idle_gpus}[${i}]  = 1;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- HIP-specific classification ---\n"
    "                    elseif ( ${paradigm} =~ /^hip:/ )\n"
    "                    {\n"
    "                        ${includesHIP} = 1;\n"
    "                        ${hip}[${i}]   = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        // HIP stream management\n"
    "                        if ( ${name} =~ /^hip(Init|StreamCreate(With(Flags|Priority))?|ExtStreamCreateWithCUMask|StreamDestroy|SetDevice)/ )\n"
    "                        {\n"
    "                            ${hip_stream}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // HIP kernel launches\n"
    "                        if ( ${name} =~ /^hip(Module|ExtModule|HccModule)?LaunchKernel$/ )\n"
    "                        {\n"
    "                            ${hip_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // HIP memory allocations\n"
    "                        if (  ${paradigm} eq \"hip:HIP_MALLOC\"\n"
    "                              or ${role} eq \"allocate\"\n "
    "                              or ${role} eq \"deallocate\"\n "
    "                              or ${role} eq \"reallocate\" )\n"
    "                        {\n"
    "                            ${hip_malloc}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // HIP memory transfers\n"
    "                        if ( ${sourcefile} eq \"hip:HIP_MEMCPY\"\n"
    "                              or ${role} eq \"rma\"\n"
    "                              or ${role} eq \"data transfer\" )\n"
    "                        {\n"
    "                            ${hip_memcpy}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // HIP synchronization\n"
    "                        if ( ${sourcefile} eq \"hip:HIP_SYNC\" \n"
    "                              or ${role} eq \"barrier\" )\n"
    "                        {\n"
    "                            ${hip_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        // HIP kernels\n"
    "                        if (  ${paradigm} eq \"hip:HIP_KERNEL\" \n"
    "                              or ${role} eq \"kernel\" )\n"
    "                        {\n"
    "                            ${hip_kernel_executions}[${i}] = 1;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- Internal measurement activity classification ---\n"
    "                    elseif ( ${paradigm} eq \"measurement\" )\n"
    "                    {\n"
    "                        if ( ${name} eq \"TRACE BUFFER FLUSH\" )\n"
    "                        {\n"
    "                            ${execution}[${i}] = 0;\n"
    "                            ${overhead}[${i}]  = 1;\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- Wrappen libraries classification ---\n"
    "                    elseif ( ${paradigm} =~ /^libwrap:(.+)$/ )\n"
    "                    {\n"
    "                        ${includesLIBWRAP} = 1;\n"
    "                        ${libwrap}[${i}] = 1;\n"
    "                    }\n"
    "\n"
    "                    //--- File I/O-specific classification ---\n"
    "                    elseif ( ${paradigm} eq \"io\" )\n"
    "                    {\n"
    "                        ${includesFILEIO} = 1;\n"
    "                        ${fileio}[${i}]   = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        if ( ${role} seq \"file io metadata\" )\n"
    "                        {\n"
    "                            ${fileio_meta}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^(aio_read|fgetc|fgets|fread|fscanf|getc|getchar|gets|pread|pread64|preadv|preadv2|preadv64|preadv64v2|read|readv|scanf|vfscanf|vscanf)$/ )\n"
    "                        {\n"
    "                            ${fileio_reading}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${name} =~ /^(aio_write|fflush|fprintf|fputc|fputs|fwrite|printf|putchar|puts|pwrite|pwrite64|pwritev|pwritev2|pwritev64|pwritev64v2|vfprintf|vprintf|write|writev)$/ )\n"
    "                        {\n"
    "                            ${fileio_writing}[${i}] = 1;\n"
    "                        };\n"
    "                    }\n"
    "\n"
    "                    //--- Memory tracking classification ---\n"
    "                    elseif ( ${paradigm} eq \"memory\" )\n"
    "                    {\n"
    "                        ${includesMEMORY} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "                    };\n"
    "\n"
    "                    ${i} = ${i} + 1;\n"
    "                };\n"
    "\n"
    "\n"
    "\n"
    "                return 0;\n"
    "            }\n";


std::string popcalculation::cubepl_time_set_str =
    "            {\n"
    "\n"
    "                if ( ${includesMPI} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::mpi(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::mpi(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "\n"
    "                if ( ${includesSHMEM} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::shmem_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::shmem_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "\n"
    "                if ( ${includesOpenMP} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::omp_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::omp_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "                if ( ${includesOpenMPTarget} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::omp_target_kernels_executions(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::omp_target_kernels_executions(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"    "\n"
    "                if ( ${includesPthread} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::pthread_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::pthread_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "\n"
    "                if ( ${includesOpenACC} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::openacc_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::openacc_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                    if ( cube::metric::get::openacc_kernel_executions(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::openacc_kernel_executions(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "\n"
    "                if ( ${includesOpenCL} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::opencl_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::opencl_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                    if ( cube::metric::get::opencl_kernel_executions(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::opencl_kernel_executions(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "\n"
    "                if ( ${includesCUDA} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::cuda_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::cuda_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                    if ( cube::metric::get::cuda_kernel_executions(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::cuda_kernel_executions(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "\n"
    "                if ( ${includesHIP} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::hip_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::hip_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                    if ( cube::metric::get::hip_kernel_executions(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::hip_kernel_executions(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "                if ( ( ${includesHIP} == 0 ) and ( ${includesCUDA} == 0 ) and ( ${includesOpenCL} == 0 )  and ( ${includesOpenACC} == 0 ) and ( ${includesOpenMPTarget} == 0 ))\n"
    "                {\n"
    "                         cube::metric::set::cuda_kernel_executions(\"value\", \"VOID\");\n"
    "                         cube::metric::set::hip_kernel_executions(\"value\", \"VOID\");\n"
    "                         cube::metric::set::opencl_kernel_executions(\"value\", \"VOID\");\n"
    "                         cube::metric::set::openacc_kernel_executions(\"value\", \"VOID\");\n"
    "                         cube::metric::set::omp_target_kernels_executions(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                if ( ${includesLIBWRAP} == 0 )\n"
    "                {\n"
    "                    if ( cube::metric::get::libwrap_time(\"attribute\", \"origin\") eq \"advisor\") \n"
    "                    { \n"
    "                         cube::metric::set::libwrap_time(\"value\", \"VOID\");\n"
    "                    };\n"
    "                };\n"
    "\n"
    "                return 0;\n"
    "            }";
