/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_PERFORMANCE_ANALYSIS_H
#define CUBELIB_PERFORMANCE_ANALYSIS_H

#include <string>
#include <list>
#include "CubeProxy.h"

namespace popcalculation
{
class AdvisorAdvice;
class PerformanceTest;


class PerformanceAnalysis
{
protected:

    cube::CubeProxy* cube;
    cube::Cnode*     root_cnode;
    std::string      test_name;

    void
    findRoot();


public:
    PerformanceAnalysis( cube::CubeProxy* _cube )
    {
        cube = _cube;
        if ( cube != nullptr )
        {
            findRoot();
        }
    }

    virtual
    ~PerformanceAnalysis()
    {
    };

    virtual
    inline
    std::string
    name() const
    {
        return "";
    };


    virtual
    std::string
    getAnchorHowToMeasure() = 0;

    virtual
    std::list<PerformanceTest*>
    getAllTestsForCalculation() = 0; // returns list of tests, which can be calculated independentely in sepaate tasks

    virtual
    std::list<PerformanceTest*>
    getPOPTests() = 0;

    virtual
    std::list<PerformanceTest*>
    getGPUTests() = 0;

    virtual
    std::list<PerformanceTest*>
    getIOTests() = 0;   // computation, IRC, Stalled

    virtual
    std::list<PerformanceTest*>
    getAdditionalTests() = 0;   // computation, IRC, Stalled

    virtual
    std::list<PerformanceTest*>
    getControlTests() = 0;   // computation, IRC, Stalled


// ------ overview tests ---------

    virtual
    bool
    isActive() const = 0;
};
};

#endif // ADVISER_RATING_WIDGET_H
