/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2025                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_PRINT_EXPRESSION_EVALUATION_H
#define CUBELIB_PRINT_EXPRESSION_EVALUATION_H 0

#include <algorithm>
#include "CubeStringEvaluation.h"
#include "CubeUnaryEvaluation.h"
#include "Cube.h"
namespace cube
{
class PrintExpressionEvaluation : public UnaryEvaluation
{
public:
    PrintExpressionEvaluation( GeneralEvaluation* );

    virtual
    ~PrintExpressionEvaluation();

    virtual
    double
    eval() const
    {
        StringEvaluation* _s = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        if ( _s != nullptr )
        {
            std::string str = _s->strEval();
            std::cout << str;
        }
        else
        {
            double v = arguments[ 0 ]->eval();
            std::cout << v;
        }
        std::cout << std::endl;
        return 0.;
    }


    virtual
    double
    eval( const Cnode*             c,
          const CalculationFlavour cf,
          const Sysres*            s,
          const CalculationFlavour sf  ) const
    {
        StringEvaluation* _s = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        if ( _s != nullptr )
        {
            std::string str = _s->strEval();
            std::cout << str;
        }
        else
        {
            double v = arguments[ 0 ]->eval( c, cf, s, sf );
            std::cout << v;
            std::cout << std::endl;
        }
        return 0.;
    };

    virtual
    double
    eval( const Cnode*             c,
          const CalculationFlavour cf ) const
    {
        StringEvaluation* _s = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        if ( _s != nullptr )
        {
            std::string str = _s->strEval();
            std::cout << str;
        }
        else
        {
            double v = arguments[ 0 ]->eval( c, cf );
            std::cout << v;
            std::cout << std::endl;
        }
        return 0.;
    };


    virtual
    double*
    eval_row( const Cnode*             c,
              const CalculationFlavour cf ) const
    {
        StringEvaluation* _s = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        if ( _s != nullptr )
        {
            std::string str = _s->strEval();
            std::cout << str;
        }
        else
        {
            double* v = arguments[ 0 ]->eval_row( c, cf );
            std::for_each( v, v + row_size, [ ]( const double _d ){
                    std::cout << _d << ",";
                } );
            std::cout << std::endl;
        }
        return nullptr;
    }


    inline
    virtual
    double
    eval( const list_of_cnodes&       c,
          const list_of_sysresources& cf ) const
    {
        StringEvaluation* _s = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        if ( _s != nullptr )
        {
            std::string str = _s->strEval();
            std::cout << str;
        }
        else
        {
            double v = arguments[ 0 ]->eval( c, cf );
            std::cout << v;
            std::cout << std::endl;
        }
        return 0;
    };

    virtual
    double*
    eval_row( const list_of_cnodes&       c,
              const list_of_sysresources& cf ) const
    {
        StringEvaluation* _s = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        if ( _s != nullptr )
        {
            std::string str = _s->strEval();
            std::cout << str;
        }
        else
        {
            double* v = arguments[ 0 ]->eval_row( c, cf );
            std::for_each( v, v + row_size, [ ]( const double _d ){
                    std::cout << _d << ",";
                } );
        }
        std::cout << std::endl;
        return nullptr;
    };





    virtual
    void
    print() const
    {
        std::cout << "print(";
        arguments[ 0 ]->print();
        std::cout << ");";
    };

    virtual
    double
    eval( double c,
          double f ) const
    {
        double v = arguments[ 0 ]->eval( c, f );
        std::cout << v;
        return 0;
    };
};
};

#endif
