/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2025                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_CALLPATH_GET_EVALUATION_H
#define CUBELIB_CALLPATH_GET_EVALUATION_H 0

#include "CubeStringEvaluation.h"
#include "Cube.h"

namespace cube
{
class CallpathGetEvaluation : public StringEvaluation
{
protected:
    cube::Cube* cube;
public:
    CallpathGetEvaluation( Cube*,
                           GeneralEvaluation*,
                           GeneralEvaluation*,
                           GeneralEvaluation* );

    virtual
    ~CallpathGetEvaluation();

    virtual
    std::string
    strEval() const;


    virtual
    void
    print() const
    {
        std::cout << " cube::callpath::get(";
        arguments[ 0 ]->print();
        std::cout << ",";
        arguments[ 1 ]->print();
        std::cout << ",";
        arguments[ 2 ]->print();
        std::cout << ")";
    };
};
};
#endif
