/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBE_SIMPLE_SEMAPHORE
#define CUBE_SIMPLE_SEMAPHORE

#include <mutex>
#include <condition_variable>
#include <atomic>
#include <iostream>

namespace cube
{
class CubeSimpleSemaphore
{
public:

    explicit CubeSimpleSemaphore( size_t count ) : count( count - 1 )
    {
    }

    size_t
    getCount() const
    {
        return count;
    };

    bool
    isFree()
    {
        std::lock_guard<std::mutex> a( my_mutex );
        if ( count > 0 )
        {
            lock();
            return true;
        }
        return false;
    };
    void
    lock()        // call before critical section
    {
        --count;
    }
    void
    unlock()         // call after critical section
    {
        std::lock_guard<std::mutex> a( my_mutex );
        ++count;
    }

private:
    std::mutex          my_mutex;
    std::atomic<size_t> count;
};
};

#endif
