/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_CONTEXTFREEPLUGIN_H
#define CUBELIB_CONTEXTFREEPLUGIN_H

#include <string>
#include <vector>

/** cube server side plugin interface */
namespace cube
{
class CubeProxy;

class CubeServerPlugin
{
public:
    virtual ~CubeServerPlugin()
    {
    }

    virtual const char*
    name() const = 0;

    /** send data from client to plugin and receive answer */
    virtual
    std::vector<unsigned char>
    send( const std::vector<unsigned char>& input,
          cube::CubeProxy*                  cube = 0 ) = 0;
};

// the types of the class factories
typedef CubeServerPlugin* create_t ();
typedef void destroy_t ( CubeServerPlugin* );
}

#endif
