/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


/*-------------------------------------------------------------------------*/
/**
 *  @file
 *  @ingroup CUBE_lib.network
 *  @brief   class which handles server side plugins
 **/
/*-------------------------------------------------------------------------*/

#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <string>
#include <vector>
#include "CubeServerPlugin.h"

namespace cube
{
class CubeServerPlugin;

class PluginManager
{
public:
    ~PluginManager();

    void
    loadPlugins( const std::vector<std::string>& pathes,
                 uint64_t                        verbosity = 0 );

    CubeServerPlugin*
    getPlugin( const std::string& name );

    static PluginManager*
    getInstance();

private:
    PluginManager();
    static PluginManager*          single;
    std::vector<void*>             pluginHandles;
    std::vector<CubeServerPlugin*> plugins;
};
}

#endif // PLUGINMANAGER_H
