/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2025                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


/**
 * \file CubeParanoidStrategy.h
 * \brief In this strategy, rows are kept in memory as long as they are "in use".
 */
#ifndef CUBE_PARANOID_STRATEGY_H
#define CUBE_PARANOID_STRATEGY_H 0

#include <map>
#include <mutex>
#include "CubeBasicStrategy.h"

namespace cube
{
class ParanoidStrategy : public BasicStrategy
{
public:
    /**
     * @param[in] permissionToFreeAll Specifies if the strategy should
     * give permission for freeing all rows when asked
     */
    ParanoidStrategy( bool permissionToFreeAll );
    /**
     * Virtual destructor
     */
    virtual
    ~ParanoidStrategy();

    virtual void
    addRow( const cnode_id_t&        rowId,
            bool&                    readAllRows,
            std::vector<cnode_id_t>& rowsToRemove );
    virtual void
    removeRows( std::vector<cnode_id_t>& rowsWantToRemove,
                std::vector<cnode_id_t>& rowsToRemove );
    virtual bool
    permissionToFreeAll();
    virtual void
    forcedFreeAll();
    virtual void
    needRows( std::vector<cnode_id_t>& rowsToAdd,
              std::vector<cnode_id_t>& rowsToRemoveFirst );

private:
    bool                      m_permissionToFreeAll;
    std::map<cnode_id_t, int> m_rowsUsageParanoid;
    std::mutex                m_mutex;
};
}

#endif
