##*************************************************************************##
##  CUBE        http://www.scalasca.org/                                   ##
##*************************************************************************##
##  Copyright (c) 2023                                                     ##
##  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          ##
##                                                                         ##
##  This software may be modified and distributed under the terms of       ##
##  a BSD-style license.  See the COPYING file in the package base         ##
##  directory for details.                                                 ##
##*************************************************************************##



dnl Enable the build of the cube_server plugins architecture
dnl
AC_DEFUN([AC_CUBE_DLOPEN],[

    AC_ARG_ENABLE([server_plugins],
                  AS_HELP_STRING([--enable-server_plugins], [Enables support for cube_server plugins via dlopen and co calls [default=yes]]),
                  [enable_server_plugins=$enableval],
                  [enable_server_plugins="yes"])

    AS_IF([test "x$enable_server_plugins" = "xyes"],
          [AX_REQUIRE_HEADERS([dirent.h dlfcn.h],
                              [enable_server_plugins])])

    AS_IF([test "x$enable_server_plugins" = "xyes"],
          [AC_SEARCH_LIBS([dlopen], [dl],
                              [enable_server_plugins="yes"
                               CUBE_DL_LIB="-ldl"])])

    AS_IF([test "x$enable_server_plugins" = "xyes"],
          [AC_CHECK_FUNCS([dlopen dlerror], [enable_server_plugins="yes"], [enable_server_plugins="no"])])

    AS_IF([test "x$enable_server_plugins" = "xyes"],
         [HAVE_DLOPEN="yes"
          AC_DEFINE([HAVE_DLOPEN],[1],[Define if dlopen call is available])
          AC_SUBST([HAVE_DLOPEN])
          AC_SUBST([CUBE_DL_LIB])
          cube_have_dlopen=yes])

    AM_CONDITIONAL([HAVE_DLOPEN],    [test "x$enable_server_plugins" = "xyes"])
    AFS_SUMMARY([cube_server plugins], [$enable_server_plugins])
])
