/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2009-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2016                                                **
**  TU Dresden, Zentrum fuer Informationsdienste und Hochleistungsrechnen  **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


/**
 * @file
 *
 * Implements the representation and analysis of library dependencies
 */

#include <config.h>

#include <iostream>
#include <stdlib.h>
#include <cstring>

#include <cubegui_config.hpp>

#include <cubegui_config_data.hpp>

#include <config-external-libs-frontend.hpp>

using namespace std;

cubegui_config_data*
cubegui_config_get_frontend_data( void )
{
    static cubegui_config_data data;

    data.m_qmake          = "/usr/lib/qt6/bin/qmake6";
    data.m_moc            = "/usr/lib/qt6/libexec/moc";
    data.m_uic            = "/usr/lib/qt6/libexec/uic";
    data.m_rcc            = "/usr/lib/qt6/libexec/rcc";
    data.m_cubelib_config = "/CI/checkout/perftools/cicd/cubegui/_install/cubelib/bin/cubelib-config";
    data.m_cc             = "gcc";
    data.m_cxx            = "g++ -std=c++17";
    data.m_cppflags       = "-I/CI/build/_work/src/_build/_install/include/cubegui";
    data.m_incldir        = "/CI/build/_work/src/_build/_install/include/cubegui";
    data.m_use_rpath_flag = 1;
    data.m_rpath_flag_cc  = "$wl-rpath $wl$libdir";
    data.m_wl_flag        = "-Wl,";
    data.m_aix_libpath    = "";
    // No linker/loader search path filtering for now, see scorep#415
    data.m_sys_lib_search_path   = ""; // "/usr/lib/gcc/x86_64-linux-gnu/13 /usr/lib/x86_64-linux-gnu /usr/lib /lib/x86_64-linux-gnu /lib ";
    data.m_sys_lib_dlsearch_path = ""; // "/lib /usr/lib /usr/local/lib /usr/local/lib/x86_64-linux-gnu /lib/x86_64-linux-gnu /usr/lib/x86_64-linux-gnu ";

    add_library_dependencies_frontend( &data.m_library_objects );

    data.prepare_rpath_flags();

    return &data;
}
