/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2022                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUIPLUGIN_LAUNCHPLUGIN_H
#define CUBEGUIPLUGIN_LAUNCHPLUGIN_H
#include <QtGui>
#include "CubePlugin.h"
#include "PluginServices.h"
#include "LaunchInfo.h"



class LaunchPlugin : public QObject, cubepluginapi::CubePlugin
{
    Q_OBJECT
    Q_INTERFACES( cubepluginapi::CubePlugin )
    Q_PLUGIN_METADATA( IID "LaunchPlugin" )

public:
    QString
    name() const override;

    bool
    cubeOpened( cubepluginapi::PluginServices* service ) override;

    void
    cubeClosed() override;

    void
    version( int& major,
             int& minor,
             int& bugfix ) const override;

    QString
    getHelpText() const override;

    QString
    getDeactivationMessage() override;

private slots:
    void
    contextMenuIsShown( cubepluginapi::DisplayType type,
                        cubepluginapi::TreeItem*   item );
    virtual void
    orderHasChanged( const QList<cubepluginapi::DisplayType>& order );

private slots:
    void
    onLaunch();

private:
    QList<LaunchInfo*>                                                       launchInfoList;
    cubepluginapi::PluginServices*                                           service;
    QHash<int, QPair<cubepluginapi::DisplayType, cubepluginapi::TreeItem*> > contextHash;
    const cubepluginapi::TreeItemMarker*                                     marker;
    QString                                                                  deactivationMsg;
};

#endif // LAUNCHPLUGIN_H
