/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUIPLUGIN_MARKERPLUGIN_H
#define CUBEGUIPLUGIN_MARKERPLUGIN_H
#include <QWidget>
#include <QLabel>
#include <QHash>
#include "PluginServices.h"
#include "CubePlugin.h"

namespace itemmarkerplugin
{
class ItemMarkerPlugin : public QObject, public cubepluginapi::CubePlugin, cubepluginapi::SettingsHandler
{
    Q_OBJECT
    Q_INTERFACES( cubepluginapi::CubePlugin )
    Q_PLUGIN_METADATA( IID "TreeItemMarkerPlugin" ) // unique plugin name

public:
    // CubePlugin implementation
    virtual bool
    cubeOpened( cubepluginapi::PluginServices* service );
    virtual void
    cubeClosed();
    virtual QString
    name() const;
    virtual void
    version( int& major,
             int& minor,
             int& bugfix ) const;
    virtual QString
    getHelpText() const;

    virtual QString
    getHelpURL() const
    {
        return "TreeItemMarkerPlugin.html";
    }

    virtual void
    loadExperimentSettings( QSettings& );

    virtual void
    saveExperimentSettings( QSettings& );

    virtual QString
    settingName()
    {
        return "ItemMarkerPlugin";
    }

private:
    void
    markExpertMetrics();
    void
    contextMenuIsShown( cubepluginapi::DisplayType,
                        cubepluginapi::TreeItem* item );
    void
    showRelationMarker();
    void
    showCallSiteMarker();
    void
    setMarker();
    void
    removeMarker();
    void
    selectMarked();
    void
    editMarker();
    void
    tabChanged( cubepluginapi::DisplayType type );
    void
    initRelationMarker();

    cubepluginapi::PluginServices* service;

    // manually set items
    cubepluginapi::TreeItem*             contextItem;
    const cubepluginapi::TreeItemMarker* marker;
    cubepluginapi::DefaultMarkerLabel*   markerLabel;
    QList<cubepluginapi::TreeItem*>      markedItems;

    // accelerator items with corresponding creator items
    cubepluginapi::DefaultMarkerLabel*                                relationLabel;
    const cubepluginapi::TreeItemMarker*                              relationMarker;
    QList<cubepluginapi::TreeItem*>                                   markedRelationItems;
    QHash<cubepluginapi::TreeItem*, cubepluginapi::TreeItem*>         creatorItems;
    QHash<cubepluginapi::TreeItem*, QList<cubepluginapi::TreeItem*> > childItems;

    // call site items with corresponding kernel execution region and vice versa
    cubepluginapi::DefaultMarkerLabel*                        relatedTabLabel;
    const cubepluginapi::TreeItemMarker*                      relatedTabMarker;
    const cubepluginapi::TreeItemMarker*                      ghostMarker;
    const cubepluginapi::TreeItemMarker*                      voidMarker;
    QList<cubepluginapi::TreeItem*>                           markedCallSiteRelationItems;
    QList<cubepluginapi::TreeItem*>                           relatedTabItems;
    QList<cubepluginapi::TreeItem*>                           previousRelatedTabItems;
    QHash<cubepluginapi::TreeItem*, cubepluginapi::TreeItem*> callSiteItems;
};
}

#endif
