/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2022                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/



#ifndef CUBEGUIPLUGIN_VIOLINPLOT_H
#define CUBEGUIPLUGIN_VIOLINPLOT_H

#include <QWidget>
#include <QPainter>
#include <QString>

#include <utility>
#include <vector>
#include <string>

#include <Chart.h>
#include "ViolinStatistics.h"
#include "PluginServices.h"
#include "CubePlugin.h"

namespace cubegui
{
class StatisticalInformation;
}

namespace system_statistics
{
class ViolinPlot : public cubegui::Chart
{
public:
    ViolinPlot( QWidget* parent = nullptr,
                QDialog* info = nullptr );
    void
    set( const ViolinStatistics&       violinStatistics,
         const cubegui::StatisticPair& stat,
         double                        startValue );

    void
    selectKernel( DensityKernel kernel )
    {
        used_kernel = kernel;
    }

    void
    selectOrder( TaylorOrder value )
    {
        used_order = value;
    }

protected:
    std::vector<cubegui::AxisLabel>
    generateRightAxisValues() override;
    void
    drawChart( QPainter& painter ) override;
    void
    mousePressEvent( QMouseEvent* event ) override;
    void
    mouseReleaseEvent( QMouseEvent* event ) override;
    QString
    getAreaDescription() const override;

private:
    double              minimumValue, maximumValue;
    std::pair<int, int> firstPosition;
    DensityKernel       used_kernel;
    TaylorOrder         used_order;
    QDialog*            tooltip;
    QDialog*            infoDialog;
    QPoint              mousePressPos;

    ViolinStatistics       item;
    cubegui::StatisticPair statistics;

    void
    drawViolinPlot( QPainter& painter );
};
}
#endif

#ifdef SELECT_KERNELS
void
UniK( bool ok );

void
TriangK( bool ok );

void
EpaK( bool ok );

void
QuarK( bool ok );

void
TriwK( bool ok );

void
TcubeK( bool ok );

void
GaussK( bool ok );

void
CosK( bool ok );

void
LogK( bool ok );

void
SigK( bool ok );

void
SilvK( bool ok );

void
widthSlider( int );

void
orderSLider( int );

//void
// mmlines(int);

#endif
