/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef POPADVISOR_CLIENT_H
#define POPADVISOR_CLIENT_H
#include <QObject>
#include <QWidget>
#include <QTableWidget>
#include "CubeProxy.h"
#include "PluginServices.h"
#include "CubePlugin.h"
#include "TabInterface.h"
#include "Future.h"
#include "POPCalculation.h"

class QComboBox;
class QPushButton;
class QWidget;
class QLabel;
class QTableWidget;

namespace popadvisor_client
{
class CubePOPAdvisorWidget;


class POPAdvisorPlugin : public QObject, public cubepluginapi::CubePlugin, cubepluginapi::TabInterface
{
    Q_OBJECT
    Q_INTERFACES( cubepluginapi::CubePlugin )
    Q_PLUGIN_METADATA( IID "POPAdvisorPlugin" ) // unique plugin name

public:
    POPAdvisorPlugin();

    // CubePlugin implementation
    bool
    cubeOpened( cubepluginapi::PluginServices* service ) override;
    void
    cubeClosed() override;
    QString
    name() const override;
    void
    version( int& major,
             int& minor,
             int& bugfix ) const override;
    QString
    getHelpText() const override;

    // TabInterface implementation
    QString
    label() const override;
    QWidget*
    widget() override;
    void
    setActive( bool ) override;

public slots:

    void
    communicateWithServerPlugin();

private slots:
    void
    treeItemIsSelected( cubepluginapi::TreeItem* item );

    void
    calculationFinished();




private:

    popadvisor_client::CubePOPAdvisorWidget* pop_advisor_widget;
    cubepluginapi::PluginServices*           service;
    cubepluginapi::Future*                   future;

    std::mutex updateMutex;
    bool       isNetworkProxy;  // true, if cube has been loaded using cube_server

    std::vector<std::pair<std::string, popcalculation::POP_ANALYSIS> > analysisList;
    std::vector<std::vector<unsigned char> >                           analysisListResults;
    std::vector<unsigned char>                                         server_answer;

    void
    testAvailableAnalyses();
    void
    initialisationFinished();
};




/*
 * The class ParallelCalculation has to provide all data that is used for one calculation task, which is triggerd with
 * calculate(). It calculates the product of x_ and y_ and writes the result to result_.
 */
class ParallelCalculation : public cubepluginapi::Task
{
public:
    ParallelCalculation( std::string name,  cube::CubeProxy* proxy, const std::vector<unsigned char>& request, std::vector<unsigned char>* result ) : plugins_name_( name ), proxy_( proxy ), request_( request ), result_( result )
    {
    };
    virtual void
    calculate();

private:
    std::string                      plugins_name_;
    cube::CubeProxy*                 proxy_;
    const std::vector<unsigned char> request_;
    std::vector<unsigned char>*      result_;
};
}

#endif // TESTPLUGIN1_H
