/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2022-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef MEASUREMENTPLUGIN_H
#define MEASUREMENTPLUGIN_H

#include <QtGui>
#include "ContextFreePlugin.h"
#include "ContextFreeServices.h"

namespace measurementplugin
{
/**
 * @file measurementplugin.h
 * @brief Implements the ContextFreePlugin Interface.
 */
class MeasurementPlugin : public QObject, public cubepluginapi::ContextFreePlugin
{
    Q_OBJECT
    Q_INTERFACES( cubepluginapi::ContextFreePlugin )
#if QT_VERSION >= 0x050000
    Q_PLUGIN_METADATA( IID "MeasurementPlugin" )
#endif

public:
    /* ContextFreePlugin interface */
    virtual QString
    name() const;

    virtual void
    opened( cubepluginapi::ContextFreeServices* service );

    virtual void
    closed();

    virtual void
    version( int& major,
             int& minor,
             int& bugfix ) const;

    virtual QString
    getHelpText() const;

    cubepluginapi::ContextFreeServices*
    getService();

private:
    cubepluginapi::ContextFreeServices* service;
};
}

#endif // MEASUREMENTPLUGIN_H
