/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUIPLUGIN_TOOLS_DIFF_H
#define CUBEGUIPLUGIN_TOOLS_DIFF_H

#include <QDebug>
#include <QPushButton>
#include <QLabel>
#include <QCheckBox>
#include "ContextFreePlugin.h"
#include "ContextFreeServices.h"

class CubeDiff : public QObject, public cubepluginapi::ContextFreePlugin
{
    Q_OBJECT
    Q_INTERFACES( cubepluginapi::ContextFreePlugin )
    Q_PLUGIN_METADATA( IID "CubeDiffPlugin" )

public:
    // ContextFreePlugin interface
    virtual QString
    name() const;

    virtual void
    opened( cubepluginapi::ContextFreeServices* service );

    virtual void
    closed();

    virtual void
    version( int& major,
             int& minor,
             int& bugfix ) const;

    virtual QString
    getHelpText() const;

    virtual void
    setArguments( const QStringList& args )
    {
        this->args = args;
    }

private:
    cubepluginapi::ContextFreeServices* service;

    QPushButton* diff;
    QLabel*      fileLabel1;
    QLabel*      fileLabel2;
    QString      fileName1;
    QString      fileName2;
    QCheckBox*   remote;
    QCheckBox*   reduce;
    QCheckBox*   collapse;
    QStringList  args;

    void
    clearFiles();
    void
    startAction();
    void
    loadFile1();
    void
    loadFile2();
    void
    uncheckChoice();
    QString
    getFileName();
};

#endif // CUBE_TOOLS_H
