/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2022                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>

#include "JSCHybridIPCTest.h"


using namespace advisor;

JSCIPCTest::JSCIPCTest( cube::CubeProxy* cube ) : PerformanceTest( cube )
{
    setName( "IPC" );
    setWeight( 1 );   // need to be adjusted
    pop_ipc = cube->getMetric( "ipc" );
    if ( pop_ipc == nullptr )
    {
        adjustForTest( cube );
    }
    pop_ipc  = cube->getMetric( "ipc" );
    maxValue = 1.;
    if ( pop_ipc == nullptr )
    {
        setWeight( 0.1 );
        setValue( 0. );
        return;
    }
    cube::list_of_sysresources lsysres = getRootsOfSystemTree();
    cube::metric_pair          metric;
    metric.first  = pop_ipc;
    metric.second = cube::CUBE_CALCULATE_INCLUSIVE;
    lmetrics.push_back( metric );
}


void
JSCIPCTest::applyCnode( const cube::Cnode* cnode, const cube::CalculationFlavour cnf,
                        const bool )
{
    if ( pop_ipc == nullptr )
    {
        return;
    }

    cube::list_of_sysresources lsysres;
    cube::list_of_cnodes       lcnodes;

    cube::cnode_pair pcnode = std::make_pair( const_cast<cube::Cnode*>( cnode ), cnf );
    lcnodes.push_back( pcnode );

    cube::Value* v = cube->calculateValue( lmetrics,
                                           lcnodes,
                                           lsysres );
    double pop_ipc_value = v->getDouble();
    delete v;
    setValue( pop_ipc_value );
}

void
JSCIPCTest::applyCnode( const cube::list_of_cnodes& lcnodes,
                        const bool                   )
{
    if ( pop_ipc == nullptr )
    {
        return;
    }
    cube::list_of_sysresources lsysres;
    cube::Value*               v = cube->calculateValue( lmetrics,
                                                         lcnodes,
                                                         lsysres );
    double pop_ipc_value = v->getDouble();
    delete v;
    setValue( pop_ipc_value );
}

const std::string&
JSCIPCTest::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
JSCIPCTest::isActive() const
{
    return pop_ipc != nullptr;
};

bool
JSCIPCTest::isIssue() const
{
    return false;
};


void
JSCIPCTest::adjustForTest( cube::CubeProxy* cube ) const
{
    add_tot_ins_without_wait( cube );
    add_tot_cyc_without_wait( cube );
    add_ipc( cube );
}
