/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2022                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/




#ifndef CUBEGUI_VERSION_CHECK_H
#define CUBEGUI_VERSION_CHECK_H

#include <QWidget>
#include <QPainter>
#include <QString>
#include <QToolButton>
#include <QDialog>
#include <QGroupBox>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QRadioButton>
#include <QVBoxLayout>
#include <utility>
#include <vector>
#include <string>

#include <QUrl>
#include <QBuffer>

#include "Settings.h"

namespace cubegui
{
// #define UPDATE_CHECK_URL "http://www.vi-hps.org/upload/packages/cube/CUBE_LATEST_RELEASE"
#define UPDATE_CHECK_URL "https://apps.fz-juelich.de/scalasca/releases/cube/CUBE_LATEST_RELEASE"
// #define UPDATE_URL "http://www.vi-hps.org/projects/score-p/"

// this url is not 100% valid, coz i dont know yet precise url for the page, where CUBE get published
#define UPDATE_URL "https://www.scalasca.org/software/cube-4.x/cube.html"

class DownloadThread;

class VersionCheck : public QObject
{
    Q_OBJECT
public:
    VersionCheck( QWidget* parent = 0 );

    QString
    getLatestRelease()
    {
        return latestRelease;
    }

public slots:
    void
    checkForUpdates();

signals:
    void
    updateCheckFinished( const QString& msg );

private:
    QWidget*        parent;
    QUrl            url;
    DownloadThread* download;
    QString         statusMessage;
    QString         latestRelease;
    bool            update_Available;

private slots:
    void
    check( const QUrl&       url,
           const QByteArray& buffer );
};
}
#endif
