/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2020-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_APPLICATION_H
#define CUBEGUI_APPLICATION_H
#include <QApplication>
#include <QTimer>

namespace cubegui
{
class PresentationCursor;
class MainWidget;

/** CubeApplication is required for OS X to open cube by double-clicking on a cube input file and for the presentation cursor
 */
class CubeApplication : public QApplication
{
public:
    CubeApplication( int&   argc,
                     char** argv );

    /** shows an additional mouse image next to the cursor, if enabled  */
    void
    setPresentationMode( bool enabled = true );

    /** shows an additional mouse image next to the cursor, if enabled  */
    void
    emulateRightMouseMode( bool enabled = true );

    void
    setMain( cubegui::MainWidget* m );

    /** required for OS X to open cube by double-clicking on a cube input file */
    bool
    event( QEvent* event );

    /** required for special cursor in presentation mode */
    bool
    eventFilter( QObject* obj,
                 QEvent*  event );

private:
    cubegui::MainWidget* mainWidget            = nullptr;
    PresentationCursor*  pcursor               = nullptr;
    bool                 emulationIsActive     = false;
    bool                 emulateMouseIsEnabled = false;
    bool                 presentationIsEnabled = false;
    QTimer               mousePressTimer;

    void
    emulateRightMouse( QObject* obj,
                       QEvent*  event );
    void
    setPresentationCursor( QObject* obj,
                           QEvent*  event );
    void
    setEventFilter();
};
}

#endif // CUBEAPPLICATION_H
