/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2022                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_BOXPLOT_H
#define CUBEGUI_BOXPLOT_H

#include <QWidget>
#include <QPainter>
#include <QString>
#include <QDebug>
#include <QStack>

#include <utility>
#include <vector>
#include <string>
#include "Chart.h"
#include "StatisticalInformation.h"

namespace cubegui
{
class BoxPlot : public Chart
{
public:
    BoxPlot( QWidget* parent = nullptr, QDialog* info = nullptr ) : Chart( parent )
    {
        tooltip    = nullptr;
        infoDialog = info;
    }

    /** Sets the data to plot. The default scale of the x asis is set to the minimum and the maximum value. */
    void
    addStatistics( StatisticalInformation const& statistics );

    /** Sets the data to plot and the absolute values for the right axis.
     *  The default scale of the x asis is set to the minimum and the maximum value. */
    void
    setStatistics( const StatisticPair& stat );

protected:
    std::vector<AxisLabel>
    generateRightAxisValues() override;
    void
    drawChart( QPainter& painter ) override;
    void
    mousePressEvent( QMouseEvent* event ) override;
    void
    mouseReleaseEvent( QMouseEvent* event ) override;
    int
    calculateLowerBorderHeight( int chartWidth ) override;
    QString
    getAreaDescription() const override;

private:
    static const int MAX_DIGITS      = 6;  // don't show more than MAX_DIGITS decimal places
    static const int boxWidthPercent = 60; // width of the boxplot in percent of the total area excluding paddings

    int      horizontalPadding;            // padding on the left and right border of the drawing area
    int      boxAreaWidth;                 // width of the area for one boxplot
    int      boxWidth;                     // with of one boxplot
    int      boxLabelHeight;               // hight of the legend
    int      boxLabelWidth;                // width of the legend
    int      boxLabelColumns;              // number of columns of the legend
    QDialog* tooltip;                      // tooltip with additional infos about the boxplot
    QDialog* infoDialog;                   // dialog with additional infos about the boxplot
    QPoint   mousePressPos;                // mouse position of the mouse press event

    // data to be displayed
    std::vector<StatisticPair> statList;      // statistics for all boxplots

    void
    drawLegend( QPainter& painter );
    void
    drawBoxPlot( QPainter&                     painter,
                 const StatisticalInformation& stat,
                 int                           posX,
                 int                           boxWidth );
    void
    drawBoxPlots( QPainter& painter );

    const StatisticPair*
    getStatistics( int posX ) const;
    int
    getBoxplotCenter( int index ) const;
};  // end class BoxPlot
}
#endif
