/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_CALLTREEVIEW_H
#define CUBEGUI_CALLTREEVIEW_H

#include "TreeView.h"

namespace cubegui
{
class CallTreeView : public TreeView
{
    Q_OBJECT
public:
    CallTreeView( TreeModelInterface* modelInterface,
                  const QString&      tabLabel );

    virtual void
    setActive( bool );

    // settings
    void
    loadStatus( QSettings& settings );
    void
    saveStatus( QSettings& settings );
    void
    loadExperimentSettings( QSettings& settings );
    void
    saveExperimentSettings( QSettings& settings );

    virtual QString
    getContextDescription( TreeItem* item ) const;

public slots:
    void
    invalidateSelection( Tree* selectedTree );

protected:
    virtual void
    fillContextMenu();

private:
    enum CallTreeContextMenuAction { ShowIterations, HideIterations, SetAsLoop, Reroot, Prune, SetAsLeaf, Undo };
    std::unordered_map<CallTreeContextMenuAction, QAction*, std::hash<int> > callContextMenuHash; // contains all call tree specific context menu actions
    QList< std::function<void()> >                                           commands;

    bool  selectionIsInvalidated;
    Tree* selectedTree; // other tree whose selections should be selected here

    void
    createContextMenuActions();
    void
    location( TreeItem* item,
              bool      takeCallee );
    void
    executeUndoableCommand( std::function<void()> command );

    void
    rerootItems( QList<TreeItem*> items );
    void
    pruneItems( QList<TreeItem*> items );
    void
    setAsLeaf( QList<TreeItem*> items );

    void
    copySelection();

private slots:
    void
    rebuild();
    void
    setAsLoop();
    void
    showIterations();
    void
    hideIterations();
    void
    onRerootItem();
    void
    onPruneItem();
    void
    onSetAsLeaf();
    void
    undo();
    void
    onLocation();
    void
    onLocationCallee();
};
}
#endif // CALLTREEVIEW_H
