# CubeWebservice 
CubeWebservice is a Tornado-based WebSocket proxy for cube_server

## Requirements
- Python 3.6+
- Tornado
- cube_server > 4.9 (part of [cubelib](https://www.scalasca.org/software/cube-4.x/download.html))

## Installation
- Download the [tarball](https://perftools.pages.jsc.fz-juelich.de/addons/cube/supplements/cubewebservice/cube-webservice-latest.tgz)
which is build by this project and unpack it
- `cd cube-webservice && pip install .`

## Usage
1. Define the path to the cube_server executable, which is part of cubelib.  
    `export CUBE_SERVER_PATH=<path to cubelib>/bin/cube_server`  
1. Start the web service (using default port 8008)  
    `cube_webservice`  
1. Open cube in a web browser  
    `http://localhost:8008/static/cube.html`


## Options

1. Define how the service can be accessed, either a path for unix domain socket or a network port

    `cube_webservice --unix-socket <path>` or  
    `cube_webservice --port <port>`
    
1. Define how the service communicates with cube_server. If this option is omitted, an arbitrary network port will be chosen.

    `cube_webservice --unix-socket <path> --internal-socket <path>`

Optional: `export SYSTEMNAME="<server name>"` to display this name in the browser tab.

# How it works
- sets up a Tornado web server that serves the cube client (cube.html)
- starts cube_server (part of cubelib)
- proxies WebSocket connection to cube_server
